/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.aop;

import cloud.tianai.captcha.exception.CaptchaValidException;
import cloud.tianai.captcha.request.CaptchaRequest;
import cloud.tianai.captcha.slider.SliderCaptchaApplication;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptchaInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CaptchaInterceptor.class);
    private SliderCaptchaApplication captchaApplication;

    public CaptchaInterceptor(SliderCaptchaApplication captchaApplication) {
        this.captchaApplication = captchaApplication;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] arguments = invocation.getArguments();
        CaptchaRequest captchaRequest = null;
        for (Object arg : arguments) {
            if (!(arg instanceof CaptchaRequest)) continue;
            captchaRequest = (CaptchaRequest)arg;
            break;
        }
        if (captchaRequest == null) {
            log.warn("\u9a8c\u8bc1\u7801\u9a8c\u8bc1 \u65b9\u6cd5\u540d\u79f0:{} \u6ca1\u6709\u627e\u5230CaptchaRequest<?> \u5bf9\u8c61", (Object)invocation.getMethod().getName());
            return invocation.proceed();
        }
        String id = captchaRequest.getId();
        Float percentage = captchaRequest.getPercentage();
        if (StringUtils.isBlank((CharSequence)id) || percentage == null) {
            log.error("\u9a8c\u8bc1\u7801\u9a8c\u8bc1 \u65b9\u6cd5\u540d\u79f0:{} id \u6216\u8005 percentage \u4e0d\u80fd\u4e3a\u7a7a", (Object)invocation.getMethod().getName());
            throw new CaptchaValidException("id \u6216\u8005 percentage \u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean matching = this.captchaApplication.matching(id, percentage);
        if (matching) {
            return invocation.proceed();
        }
        throw new CaptchaValidException("\u9a8c\u8bc1\u5931\u8d25");
    }
}

