/*
 * Decompiled with CFR 0.152.
 */
package cloud.rio.amazonas;

import cloud.rio.amazonas.NoEncryptionKeyFoundException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.amazonaws.services.kms.model.AliasListEntry;
import com.amazonaws.services.kms.model.ListAliasesRequest;
import com.amazonaws.services.kms.model.ListAliasesResult;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterResult;
import com.amazonaws.services.simplesystemsmanagement.model.Parameter;
import com.amazonaws.services.simplesystemsmanagement.model.PutParameterRequest;
import com.amazonaws.services.simplesystemsmanagement.model.PutParameterResult;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u0006J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcloud/rio/amazonas/SsmParameterCopier;", "", "sourceCredentialsProvider", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "targetCredentialsProvider", "region", "", "(Lcom/amazonaws/auth/AWSCredentialsProvider;Lcom/amazonaws/auth/AWSCredentialsProvider;Ljava/lang/String;)V", "sourceSsm", "Lcom/amazonaws/services/simplesystemsmanagement/AWSSimpleSystemsManagement;", "targetSsm", "kmsClient", "Lcom/amazonaws/services/kms/AWSKMS;", "(Lcom/amazonaws/services/simplesystemsmanagement/AWSSimpleSystemsManagement;Lcom/amazonaws/services/simplesystemsmanagement/AWSSimpleSystemsManagement;Lcom/amazonaws/services/kms/AWSKMS;)V", "copyParameter", "", "sourceName", "targetName", "encryptionKeyName", "getKeyId", "keyName", "Companion", "amazonas"})
public final class SsmParameterCopier {
    private final AWSSimpleSystemsManagement sourceSsm;
    private final AWSSimpleSystemsManagement targetSsm;
    private final AWSKMS kmsClient;
    private static final Logger LOGGER;
    private static final boolean OVERWRITE = true;
    private static final boolean WITH_DECRYPTION = true;
    public static final Companion Companion;

    public final void copyParameter(@NotNull String sourceName, @NotNull String targetName, @NotNull String encryptionKeyName) {
        PutParameterResult putParameterResult;
        PutParameterRequest putParameterRequest;
        GetParameterResult getParameterResult;
        Intrinsics.checkParameterIsNotNull((Object)sourceName, (String)"sourceName");
        Intrinsics.checkParameterIsNotNull((Object)targetName, (String)"targetName");
        Intrinsics.checkParameterIsNotNull((Object)encryptionKeyName, (String)"encryptionKeyName");
        GetParameterResult getParameterResult2 = getParameterResult = this.sourceSsm.getParameter(new GetParameterRequest().withName(sourceName).withWithDecryption(Boolean.valueOf(true)));
        Intrinsics.checkExpressionValueIsNotNull((Object)getParameterResult2, (String)"getParameterResult");
        Parameter parameter = getParameterResult2.getParameter();
        LOGGER.info("Successfully read parameter \"{}\".", (Object)sourceName);
        if (Intrinsics.areEqual((Object)encryptionKeyName, (Object)"aws/kms") ^ true) {
            PutParameterRequest putParameterRequest2 = new PutParameterRequest().withName(targetName);
            Parameter parameter2 = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)parameter2, (String)"parameter");
            putParameterRequest = putParameterRequest2.withValue(parameter2.getValue()).withType(parameter.getType()).withKeyId(this.getKeyId(encryptionKeyName)).withOverwrite(Boolean.valueOf(true));
        } else {
            PutParameterRequest putParameterRequest3 = new PutParameterRequest().withName(targetName);
            Parameter parameter3 = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)parameter3, (String)"parameter");
            putParameterRequest = putParameterRequest3.withValue(parameter3.getValue()).withType(parameter.getType()).withOverwrite(Boolean.valueOf(true));
        }
        PutParameterRequest request = putParameterRequest;
        PutParameterResult putParameterResult2 = putParameterResult = this.targetSsm.putParameter(request);
        Intrinsics.checkExpressionValueIsNotNull((Object)putParameterResult2, (String)"putParameterResult");
        LOGGER.info("Successfully set version {} of parameter \"{}\".", (Object)putParameterResult2.getVersion(), (Object)targetName);
    }

    public static /* synthetic */ void copyParameter$default(SsmParameterCopier ssmParameterCopier, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "aws/kms";
        }
        ssmParameterCopier.copyParameter(string, string2, string3);
    }

    private final String getKeyId(String keyName) {
        String string;
        Object object;
        if (keyName == null) {
            return null;
        }
        boolean done = false;
        ListAliasesRequest request = new ListAliasesRequest();
        String alias = "alias/" + keyName;
        while (!done) {
            ListAliasesResult response;
            ListAliasesResult listAliasesResult = response = this.kmsClient.listAliases(request);
            Intrinsics.checkExpressionValueIsNotNull((Object)listAliasesResult, (String)"response");
            object = listAliasesResult.getAliases().iterator();
            while (object.hasNext()) {
                AliasListEntry entry;
                AliasListEntry aliasListEntry = entry = (AliasListEntry)object.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)aliasListEntry, (String)"entry");
                if (!Intrinsics.areEqual((Object)aliasListEntry.getAliasName(), (Object)alias)) continue;
                String keyId = entry.getTargetKeyId();
                LOGGER.info("Found matching key for alias \"{}\" with id \"{}\".", (Object)alias, (Object)keyId);
                return keyId;
            }
            if (!response.isTruncated().booleanValue()) {
                done = true;
                continue;
            }
            LOGGER.info("No key with matching alias found yet, make another request...");
            request.setMarker(response.getNextMarker());
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "No matching key found for alias \"%s\"";
        object = new Object[]{alias};
        boolean bl = false;
        Object object2 = object;
        String string3 = String.format(string2, Arrays.copyOf(object2, ((Object)object2).length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        String string4 = string = string3;
        throw (Throwable)new NoEncryptionKeyFoundException(string4);
    }

    public SsmParameterCopier(@NotNull AWSSimpleSystemsManagement sourceSsm, @NotNull AWSSimpleSystemsManagement targetSsm, @NotNull AWSKMS kmsClient) {
        Intrinsics.checkParameterIsNotNull((Object)sourceSsm, (String)"sourceSsm");
        Intrinsics.checkParameterIsNotNull((Object)targetSsm, (String)"targetSsm");
        Intrinsics.checkParameterIsNotNull((Object)kmsClient, (String)"kmsClient");
        this.sourceSsm = sourceSsm;
        this.targetSsm = targetSsm;
        this.kmsClient = kmsClient;
    }

    public SsmParameterCopier(@NotNull AWSCredentialsProvider sourceCredentialsProvider, @NotNull AWSCredentialsProvider targetCredentialsProvider, @NotNull String region) {
        Intrinsics.checkParameterIsNotNull((Object)sourceCredentialsProvider, (String)"sourceCredentialsProvider");
        Intrinsics.checkParameterIsNotNull((Object)targetCredentialsProvider, (String)"targetCredentialsProvider");
        Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
        Object object = ((AWSSimpleSystemsManagementClientBuilder)((AWSSimpleSystemsManagementClientBuilder)AWSSimpleSystemsManagementClientBuilder.standard().withRegion(region)).withCredentials(sourceCredentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"AWSSimpleSystemsManageme\u2026dentialsProvider).build()");
        AWSSimpleSystemsManagement aWSSimpleSystemsManagement = (AWSSimpleSystemsManagement)object;
        Object object2 = ((AWSSimpleSystemsManagementClientBuilder)((AWSSimpleSystemsManagementClientBuilder)AWSSimpleSystemsManagementClientBuilder.standard().withRegion(region)).withCredentials(targetCredentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"AWSSimpleSystemsManageme\u2026dentialsProvider).build()");
        AWSSimpleSystemsManagement aWSSimpleSystemsManagement2 = (AWSSimpleSystemsManagement)object2;
        Object object3 = ((AWSKMSClientBuilder)((AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withRegion(region)).withCredentials(targetCredentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"AWSKMSClientBuilder.stan\u2026dentialsProvider).build()");
        this(aWSSimpleSystemsManagement, aWSSimpleSystemsManagement2, (AWSKMS)object3);
    }

    static {
        Companion = new Companion(null);
        LOGGER = LogManager.getLogger(SsmParameterCopier.class);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcloud/rio/amazonas/SsmParameterCopier$Companion;", "", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "OVERWRITE", "", "WITH_DECRYPTION", "amazonas"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

