/*
 * Decompiled with CFR 0.152.
 */
package cloud.rio.amazonas;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.InputMismatchException;
import java.util.Scanner;
import java.util.UUID;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcloud/rio/amazonas/MfaCredentialsProvider;", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "profileName", "", "guiEnabled", "", "sessionLengthSeconds", "(Ljava/lang/String;ZLjava/lang/String;)V", "cacheExpiration", "Ljava/util/Date;", "cacheFileName", "cachedCredentials", "Lcom/amazonaws/auth/BasicSessionCredentials;", "profile", "Lcom/amazonaws/auth/profile/internal/BasicProfile;", "getCredentials", "persistCredentials", "", "credentials", "Lcom/amazonaws/services/securitytoken/model/Credentials;", "promptForMfaCode", "readOrRenewCredentials", "readPersistedCredentials", "refresh", "requestFreshCredentials", "requestMfaInputWithGui", "updateCachedCredentials", "amazonas"})
public final class MfaCredentialsProvider
implements AWSCredentialsProvider {
    private final BasicProfile profile;
    private BasicSessionCredentials cachedCredentials;
    private Date cacheExpiration;
    private final String cacheFileName;
    private final boolean guiEnabled;
    private final String sessionLengthSeconds;

    @NotNull
    public BasicSessionCredentials getCredentials() {
        if (new Date().before(this.cacheExpiration)) {
            BasicSessionCredentials basicSessionCredentials = this.cachedCredentials;
            if (basicSessionCredentials == null) {
                basicSessionCredentials = this.updateCachedCredentials();
            }
            return basicSessionCredentials;
        }
        return this.updateCachedCredentials();
    }

    private final BasicSessionCredentials updateCachedCredentials() {
        BasicSessionCredentials returnCredentials;
        Credentials credentials = this.readOrRenewCredentials();
        this.cachedCredentials = returnCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        Date date = credentials.getExpiration();
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"credentials.expiration");
        this.cacheExpiration = date;
        return returnCredentials;
    }

    private final Credentials readOrRenewCredentials() {
        Credentials credentials = this.readPersistedCredentials();
        if (credentials == null || new Date().after(credentials.getExpiration())) {
            credentials = this.requestFreshCredentials();
            this.persistCredentials(credentials);
        }
        return credentials;
    }

    private final Credentials requestFreshCredentials() {
        AssumeRoleResult roleResult;
        String roleArn = this.profile.getRoleArn();
        String mfaSerial = this.profile.getPropertyValue("mfa_serial");
        AWSCredentials sourceProfileCredentials = new ProfileCredentialsProvider(this.profile.getRoleSourceProfile()).getCredentials();
        String mfaCode = this.promptForMfaCode();
        AWSSecurityTokenService sts = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(this.profile.getRegion())).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(sourceProfileCredentials))).build();
        AssumeRoleRequest roleRequest = new AssumeRoleRequest().withTokenCode(mfaCode).withDurationSeconds(Integer.valueOf(Integer.parseInt(this.sessionLengthSeconds))).withSerialNumber(mfaSerial).withRoleArn(roleArn).withRoleSessionName(UUID.randomUUID().toString());
        AssumeRoleResult assumeRoleResult = roleResult = sts.assumeRole(roleRequest);
        Intrinsics.checkExpressionValueIsNotNull((Object)assumeRoleResult, (String)"roleResult");
        Credentials credentials = assumeRoleResult.getCredentials();
        Intrinsics.checkExpressionValueIsNotNull((Object)credentials, (String)"roleResult.credentials");
        return credentials;
    }

    private final Credentials readPersistedCredentials() {
        File f = new File(this.cacheFileName);
        if (f.exists() && !f.isDirectory()) {
            Credentials credentials = null;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.cacheFileName));
                String json = reader.readLine();
                reader.close();
                Object object = new Gson().fromJson(json, Credentials.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Gson().fromJson(json, Credentials::class.java)");
                credentials = (Credentials)object;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            return credentials;
        }
        return null;
    }

    private final void persistCredentials(Credentials credentials) {
        Gson gson = new Gson();
        String json = gson.toJson((Object)credentials);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.cacheFileName));
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final String promptForMfaCode() {
        String mfaCode;
        String string;
        if (this.guiEnabled) {
            string = this.requestMfaInputWithGui();
        } else {
            Scanner in = new Scanner(System.in);
            String string2 = "Please enter MFA Code: ";
            boolean bl = false;
            System.out.print((Object)string2);
            string = in.nextLine();
        }
        String string3 = mfaCode = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mfaCode");
        CharSequence charSequence = string3;
        boolean bl = false;
        if (charSequence.length() == 0 || mfaCode.length() < 6) {
            throw (Throwable)new InputMismatchException("You must enter a valid MFA Code!");
        }
        return mfaCode;
    }

    private final String requestMfaInputWithGui() {
        JDialog d;
        JPanel panel = new JPanel();
        JTextField mfaField = new JTextField(10);
        panel.add(new JLabel("Please enter MFA Code: "));
        panel.add(mfaField);
        JOptionPane pane2 = new JOptionPane(mfaField, panel, panel, 3, 2){
            final /* synthetic */ JTextField $mfaField;
            final /* synthetic */ JPanel $panel;

            public void selectInitialValue() {
                this.$mfaField.requestFocusInWindow();
            }
            {
                this.$mfaField = $captured_local_variable$0;
                this.$panel = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        };
        JDialog jDialog = d = pane2.createDialog("MFA Input");
        Intrinsics.checkExpressionValueIsNotNull((Object)jDialog, (String)"d");
        jDialog.setAlwaysOnTop(true);
        d.setVisible(true);
        String string = mfaField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mfaField.text");
        return string;
    }

    public void refresh() {
        throw (Throwable)new UnsupportedOperationException("refresh method is not implemented");
    }

    public MfaCredentialsProvider(@NotNull String profileName, boolean guiEnabled, @NotNull String sessionLengthSeconds) {
        Intrinsics.checkParameterIsNotNull((Object)profileName, (String)"profileName");
        Intrinsics.checkParameterIsNotNull((Object)sessionLengthSeconds, (String)"sessionLengthSeconds");
        this.guiEnabled = guiEnabled;
        this.sessionLengthSeconds = sessionLengthSeconds;
        BasicProfile basicProfile = (BasicProfile)new ProfilesConfigFile().getAllBasicProfiles().get(profileName);
        if (basicProfile == null) {
            throw (Throwable)new IllegalArgumentException("cannot initialize MFA Provider. No profileName named " + profileName + " found on your machine. Please check your .aws/credentials file");
        }
        this.profile = basicProfile;
        this.cacheExpiration = new Date();
        this.cacheFileName = "/tmp/aws-session-credentials-" + profileName;
    }

    public /* synthetic */ MfaCredentialsProvider(String string, boolean bl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string2 = "3600";
        }
        this(string, bl, string2);
    }
}

