/*
 * Decompiled with CFR 0.152.
 */
package cloud.rio.amazonas;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\rH\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J&\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcloud/rio/amazonas/HttpToS3Loader;", "", "credentialsProvider", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "region", "", "(Lcom/amazonaws/auth/AWSCredentialsProvider;Ljava/lang/String;)V", "client", "Lcom/amazonaws/services/s3/AmazonS3;", "(Lcom/amazonaws/services/s3/AmazonS3;)V", "createParentFolder", "", "localPath", "Ljava/io/File;", "deleteLocalFile", "downloadFromUrl", "url", "localFile", "isTargetPresent", "", "md5", "bucket", "key", "loadIfNotPresent", "uploadToS3", "Companion", "amazonas"})
public final class HttpToS3Loader {
    private final AmazonS3 client;
    private static final Logger LOGGER;
    public static final Companion Companion;

    public final void loadIfNotPresent(@NotNull String url, @NotNull String md5, @NotNull String bucket, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)md5, (String)"md5");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (this.isTargetPresent(md5, bucket, key)) {
            LOGGER.info("Object s3://" + bucket + '/' + key + " already there with matching hash, skipping.");
        } else {
            LOGGER.info("Object s3://" + bucket + '/' + key + " not found or hash does not match.");
            File localPath = new File("./" + key);
            this.createParentFolder(localPath);
            this.downloadFromUrl(url, localPath);
            this.uploadToS3(localPath, bucket, key);
            this.deleteLocalFile(localPath);
        }
    }

    private final boolean isTargetPresent(String md5, String bucket, String key) {
        boolean bl;
        if (!this.client.doesObjectExist(bucket, key)) {
            bl = false;
        } else {
            ObjectMetadata objectMetadata = this.client.getObjectMetadata(bucket, key);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectMetadata, (String)"client.getObjectMetadata(bucket, key)");
            bl = Intrinsics.areEqual((Object)objectMetadata.getETag(), (Object)md5);
        }
        return bl;
    }

    private final void createParentFolder(File localPath) {
        File localFolder = new File(localPath.getParent());
        if (!localFolder.exists() && localFolder.mkdirs()) {
            LOGGER.info("Created directory " + localFolder.getAbsolutePath());
        }
    }

    private final void downloadFromUrl(String url, File localFile) {
        LOGGER.info("Downloading from URL " + url + "...");
        URL website = new URL(url);
        ReadableByteChannel rbc = Channels.newChannel(website.openStream());
        FileOutputStream fos = new FileOutputStream(localFile);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
    }

    private final void uploadToS3(File localPath, String bucket, String key) {
        LOGGER.info("Uploading " + key + " to s3://" + bucket + "...");
        PutObjectRequest request = new PutObjectRequest(bucket, key, localPath);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        metadata.setCacheControl("no-cache, no-store");
        request.setMetadata(metadata);
        this.client.putObject(request);
    }

    private final void deleteLocalFile(File localPath) {
        if (localPath.delete()) {
            LOGGER.info("Deleted " + localPath);
        } else {
            LOGGER.warn("Deletion of " + localPath + " failed.");
        }
    }

    public HttpToS3Loader(@NotNull AmazonS3 client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
    }

    public HttpToS3Loader(@NotNull AWSCredentialsProvider credentialsProvider, @NotNull String region) {
        Intrinsics.checkParameterIsNotNull((Object)credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
        Object object = ((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(region)).withCredentials(credentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"AmazonS3ClientBuilder\n  \u2026                 .build()");
        this((AmazonS3)object);
    }

    static {
        Companion = new Companion(null);
        LOGGER = LogManager.getLogger(HttpToS3Loader.class);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcloud/rio/amazonas/HttpToS3Loader$Companion;", "", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "amazonas"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

