/*
 * Decompiled with CFR 0.152.
 */
package cloud.rio.amazonas;

import cloud.rio.amazonas.PipelineFailedException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.codepipeline.AWSCodePipeline;
import com.amazonaws.services.codepipeline.AWSCodePipelineClientBuilder;
import com.amazonaws.services.codepipeline.model.GetPipelineExecutionRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineExecutionResult;
import com.amazonaws.services.codepipeline.model.PipelineExecution;
import com.amazonaws.services.codepipeline.model.PipelineExecutionNotFoundException;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionRequest;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u000eJ \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcloud/rio/amazonas/CodePipelineRunner;", "", "credentialsProvider", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "region", "", "(Lcom/amazonaws/auth/AWSCredentialsProvider;Ljava/lang/String;)V", "awsCodePipeline", "Lcom/amazonaws/services/codepipeline/AWSCodePipeline;", "(Lcom/amazonaws/services/codepipeline/AWSCodePipeline;)V", "retrieveCurrentPipelineStatus", "pipelineName", "pipelineExecutionId", "loopWait", "", "startPipelineAndReturnExecutionId", "startPipelineAndWaitForSuccess", "", "sleepWhileWaitingInSec", "waitForFinalPipelineStatus", "Companion", "amazonas"})
public final class CodePipelineRunner {
    private final AWSCodePipeline awsCodePipeline;
    private static final String waitingPipelineStatus = "InProgress";
    private static final List<String> failedPipelineStatuses;
    private static final int waitForFinalPipelineStatusTimeout = 600;
    private static final int retrieveCurrentPipelineStatusTimeout = 60;
    private static final Logger LOGGER;
    public static final Companion Companion;

    public final void startPipelineAndWaitForSuccess(@NotNull String pipelineName, int sleepWhileWaitingInSec) {
        Intrinsics.checkParameterIsNotNull((Object)pipelineName, (String)"pipelineName");
        String pipelineExecutionId = this.startPipelineAndReturnExecutionId(pipelineName);
        String finalPipelineStatus = this.waitForFinalPipelineStatus(pipelineName, pipelineExecutionId, sleepWhileWaitingInSec);
        if (failedPipelineStatuses.contains(finalPipelineStatus)) {
            throw (Throwable)new PipelineFailedException("Pipeline " + pipelineName + " has final status " + finalPipelineStatus);
        }
    }

    public static /* synthetic */ void startPipelineAndWaitForSuccess$default(CodePipelineRunner codePipelineRunner, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 10;
        }
        codePipelineRunner.startPipelineAndWaitForSuccess(string, n);
    }

    private final String startPipelineAndReturnExecutionId(String pipelineName) {
        StartPipelineExecutionResult startPipelineExecutionResult;
        StartPipelineExecutionResult startPipelineExecutionResult2 = startPipelineExecutionResult = this.awsCodePipeline.startPipelineExecution(new StartPipelineExecutionRequest().withName(pipelineName));
        Intrinsics.checkExpressionValueIsNotNull((Object)startPipelineExecutionResult2, (String)"startPipelineExecutionResult");
        String string = startPipelineExecutionResult2.getPipelineExecutionId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"startPipelineExecutionResult.pipelineExecutionId");
        return string;
    }

    private final String retrieveCurrentPipelineStatus(String pipelineName, String pipelineExecutionId, int loopWait) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + (long)60000) {
            try {
                GetPipelineExecutionResult getPipelineExecutionResult;
                Thread.sleep(loopWait * 1000);
                GetPipelineExecutionResult getPipelineExecutionResult2 = getPipelineExecutionResult = this.awsCodePipeline.getPipelineExecution(new GetPipelineExecutionRequest().withPipelineName(pipelineName).withPipelineExecutionId(pipelineExecutionId));
                Intrinsics.checkExpressionValueIsNotNull((Object)getPipelineExecutionResult2, (String)"getPipelineExecutionResult");
                PipelineExecution pipelineExecution = getPipelineExecutionResult2.getPipelineExecution();
                Intrinsics.checkExpressionValueIsNotNull((Object)pipelineExecution, (String)"getPipelineExecutionResult.pipelineExecution");
                String string = pipelineExecution.getStatus();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getPipelineExecutionResu\u2026.pipelineExecution.status");
                return string;
            }
            catch (PipelineExecutionNotFoundException e) {
                LOGGER.info((Object)e);
            }
        }
        throw (Throwable)new PipelineExecutionNotFoundException("Can't find execution id " + pipelineExecutionId + " for pipeline " + pipelineName + " after 60 secs.");
    }

    private final String waitForFinalPipelineStatus(String pipelineName, String pipelineExecutionId, int loopWait) {
        boolean pipelineFinished = false;
        String finalPipelineStatus = failedPipelineStatuses.get(0);
        long start = System.currentTimeMillis();
        while (!pipelineFinished) {
            if (System.currentTimeMillis() > start + (long)600000) {
                throw (Throwable)new RuntimeException("Timeout");
            }
            String pipelineStatus = this.retrieveCurrentPipelineStatus(pipelineName, pipelineExecutionId, loopWait);
            LOGGER.info("Current status of " + pipelineName + " is " + pipelineStatus);
            if (Intrinsics.areEqual((Object)pipelineStatus, (Object)waitingPipelineStatus) ^ true) {
                pipelineFinished = true;
                finalPipelineStatus = pipelineStatus;
                continue;
            }
            Thread.sleep(loopWait * 1000);
        }
        return finalPipelineStatus;
    }

    public CodePipelineRunner(@NotNull AWSCodePipeline awsCodePipeline) {
        Intrinsics.checkParameterIsNotNull((Object)awsCodePipeline, (String)"awsCodePipeline");
        this.awsCodePipeline = awsCodePipeline;
    }

    public CodePipelineRunner(@NotNull AWSCredentialsProvider credentialsProvider, @NotNull String region) {
        Intrinsics.checkParameterIsNotNull((Object)credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
        Object object = ((AWSCodePipelineClientBuilder)((AWSCodePipelineClientBuilder)AWSCodePipelineClientBuilder.standard().withRegion(region)).withCredentials(credentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"AWSCodePipelineClientBui\u2026                 .build()");
        this((AWSCodePipeline)object);
    }

    static {
        Companion = new Companion(null);
        failedPipelineStatuses = CollectionsKt.listOf((Object[])new String[]{"Failed", "Superseded"});
        LOGGER = LogManager.getLogger(CodePipelineRunner.class);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcloud/rio/amazonas/CodePipelineRunner$Companion;", "", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "failedPipelineStatuses", "", "", "retrieveCurrentPipelineStatusTimeout", "", "waitForFinalPipelineStatusTimeout", "waitingPipelineStatus", "amazonas"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

