/*
 * Decompiled with CFR 0.152.
 */
package cloud.rio.amazonas;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.certificatemanager.AWSCertificateManager;
import com.amazonaws.services.certificatemanager.AWSCertificateManagerClientBuilder;
import com.amazonaws.services.certificatemanager.model.CertificateDetail;
import com.amazonaws.services.certificatemanager.model.CertificateSummary;
import com.amazonaws.services.certificatemanager.model.DescribeCertificateRequest;
import com.amazonaws.services.certificatemanager.model.DescribeCertificateResult;
import com.amazonaws.services.certificatemanager.model.DomainValidation;
import com.amazonaws.services.certificatemanager.model.ListCertificatesRequest;
import com.amazonaws.services.certificatemanager.model.ListCertificatesResult;
import com.amazonaws.services.certificatemanager.model.RequestCertificateRequest;
import com.amazonaws.services.certificatemanager.model.RequestCertificateResult;
import com.amazonaws.services.certificatemanager.model.ResourceRecord;
import com.amazonaws.services.certificatemanager.model.ValidationMethod;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.AmazonRoute53ClientBuilder;
import com.amazonaws.services.route53.model.Change;
import com.amazonaws.services.route53.model.ChangeBatch;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.HostedZone;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B)\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcloud/rio/amazonas/CertificateClient;", "", "credentialsProvider", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "region", "", "(Lcom/amazonaws/auth/AWSCredentialsProvider;Ljava/lang/String;)V", "acmClient", "Lcom/amazonaws/services/certificatemanager/AWSCertificateManager;", "route53Client", "Lcom/amazonaws/services/route53/AmazonRoute53;", "validationCheckIntervalMillis", "", "validationDNSEntryTTL", "(Lcom/amazonaws/services/certificatemanager/AWSCertificateManager;Lcom/amazonaws/services/route53/AmazonRoute53;JJ)V", "getHostedZoneId", "hostedZoneName", "requestAndValidateNewCertificate", "domainName", "retrieveExistingCertificate", "retrieveOrRequestCertificate", "amazonas"})
public final class CertificateClient {
    private final AWSCertificateManager acmClient;
    private final AmazonRoute53 route53Client;
    private final long validationCheckIntervalMillis;
    private final long validationDNSEntryTTL;

    @NotNull
    public final String retrieveOrRequestCertificate(@NotNull String hostedZoneName, @NotNull String domainName) {
        Intrinsics.checkParameterIsNotNull((Object)hostedZoneName, (String)"hostedZoneName");
        Intrinsics.checkParameterIsNotNull((Object)domainName, (String)"domainName");
        String string = this.retrieveExistingCertificate(domainName);
        if (string == null) {
            string = this.requestAndValidateNewCertificate(domainName, hostedZoneName);
        }
        return string;
    }

    private final String retrieveExistingCertificate(String domainName) {
        ListCertificatesResult listCertificatesResult = null;
        do {
            Object v4;
            block2: {
                ListCertificatesResult listCertificatesResult2 = listCertificatesResult;
                ListCertificatesResult listCertificatesResult3 = listCertificatesResult = this.acmClient.listCertificates(new ListCertificatesRequest().withNextToken(listCertificatesResult2 != null ? listCertificatesResult2.getNextToken() : null));
                Intrinsics.checkExpressionValueIsNotNull((Object)listCertificatesResult3, (String)"listCertificatesResult");
                List list = listCertificatesResult3.getCertificateSummaryList();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"listCertificatesResult.certificateSummaryList");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CertificateSummary it = (CertificateSummary)element$iv;
                    boolean bl = false;
                    CertificateSummary certificateSummary = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)certificateSummary, (String)"it");
                    if (!Intrinsics.areEqual((Object)certificateSummary.getDomainName(), (Object)domainName)) continue;
                    v4 = element$iv;
                    break block2;
                }
                v4 = null;
            }
            CertificateSummary existingCertificate = v4;
            if (existingCertificate == null) continue;
            return existingCertificate.getCertificateArn();
        } while (listCertificatesResult.getNextToken() != null);
        return null;
    }

    private final String requestAndValidateNewCertificate(String domainName, String hostedZoneName) {
        Object object;
        RequestCertificateResult newCertificate = this.acmClient.requestCertificate(new RequestCertificateRequest().withDomainName(domainName).withValidationMethod(ValidationMethod.DNS));
        DomainValidation validation = null;
        do {
            DescribeCertificateResult describeCertificate;
            DescribeCertificateRequest describeCertificateRequest = new DescribeCertificateRequest();
            RequestCertificateResult requestCertificateResult = newCertificate;
            Intrinsics.checkExpressionValueIsNotNull((Object)requestCertificateResult, (String)"newCertificate");
            DescribeCertificateResult describeCertificateResult = describeCertificate = this.acmClient.describeCertificate(describeCertificateRequest.withCertificateArn(requestCertificateResult.getCertificateArn()));
            Intrinsics.checkExpressionValueIsNotNull((Object)describeCertificateResult, (String)"describeCertificate");
            CertificateDetail certificateDetail = describeCertificateResult.getCertificate();
            Intrinsics.checkExpressionValueIsNotNull((Object)certificateDetail, (String)"describeCertificate.certificate");
            List list = certificateDetail.getDomainValidationOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"describeCertificate.cert\u2026e.domainValidationOptions");
            object = CollectionsKt.first((List)list);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"describeCertificate.cert\u2026ValidationOptions.first()");
        } while (Intrinsics.areEqual((Object)(validation = (DomainValidation)object).getValidationStatus(), (Object)"PENDING_VALIDATION") ^ true);
        ResourceRecord resourceRecord = validation.getResourceRecord();
        ResourceRecordSet resourceRecordSet = new ResourceRecordSet();
        ResourceRecord resourceRecord2 = resourceRecord;
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceRecord2, (String)"resourceRecord");
        ResourceRecordSet resourceRecordSet2 = resourceRecordSet.withName(resourceRecord2.getName()).withType(resourceRecord.getType()).withTTL(Long.valueOf(this.validationDNSEntryTTL)).withResourceRecords(new com.amazonaws.services.route53.model.ResourceRecord[]{new com.amazonaws.services.route53.model.ResourceRecord().withValue(resourceRecord.getValue())});
        String hostedZoneId = this.getHostedZoneId(hostedZoneName);
        this.route53Client.changeResourceRecordSets(new ChangeResourceRecordSetsRequest().withHostedZoneId(hostedZoneId).withChangeBatch(new ChangeBatch().withChanges(new Change[]{new Change().withAction("UPSERT").withResourceRecordSet(resourceRecordSet2)})));
        do {
            DescribeCertificateResult describeCertificate;
            DescribeCertificateResult describeCertificateResult = describeCertificate = this.acmClient.describeCertificate(new DescribeCertificateRequest().withCertificateArn(newCertificate.getCertificateArn()));
            Intrinsics.checkExpressionValueIsNotNull((Object)describeCertificateResult, (String)"describeCertificate");
            CertificateDetail certificateDetail = describeCertificateResult.getCertificate();
            Intrinsics.checkExpressionValueIsNotNull((Object)certificateDetail, (String)"describeCertificate.certificate");
            List list = certificateDetail.getDomainValidationOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"describeCertificate.cert\u2026e.domainValidationOptions");
            Object object2 = CollectionsKt.first((List)list);
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"describeCertificate.cert\u2026ValidationOptions.first()");
            validation = (DomainValidation)object2;
            String string = "Waiting for certificate to be validated. Current status: " + validation.getValidationStatus();
            boolean bl = false;
            System.out.println((Object)string);
            Thread.sleep(this.validationCheckIntervalMillis);
        } while (Intrinsics.areEqual((Object)validation.getValidationStatus(), (Object)"SUCCESS") ^ true);
        String string = newCertificate.getCertificateArn();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newCertificate.certificateArn");
        return string;
    }

    private final String getHostedZoneId(String hostedZoneName) {
        ListHostedZonesResult listHostedZonesResult = null;
        do {
            Object v4;
            block2: {
                ListHostedZonesResult listHostedZonesResult2 = listHostedZonesResult;
                ListHostedZonesResult listHostedZonesResult3 = listHostedZonesResult = this.route53Client.listHostedZones(new ListHostedZonesRequest().withMarker(listHostedZonesResult2 != null ? listHostedZonesResult2.getMarker() : null));
                Intrinsics.checkExpressionValueIsNotNull((Object)listHostedZonesResult3, (String)"listHostedZonesResult");
                List list = listHostedZonesResult3.getHostedZones();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"listHostedZonesResult.hostedZones");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HostedZone it = (HostedZone)element$iv;
                    boolean bl = false;
                    HostedZone hostedZone = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hostedZone, (String)"it");
                    if (!Intrinsics.areEqual((Object)hostedZone.getName(), (Object)(hostedZoneName + '.'))) continue;
                    v4 = element$iv;
                    break block2;
                }
                v4 = null;
            }
            HostedZone hostedZone = v4;
            if (hostedZone == null) continue;
            return hostedZone.getId();
        } while (listHostedZonesResult.getMarker() != null);
        return null;
    }

    public CertificateClient(@NotNull AWSCertificateManager acmClient, @NotNull AmazonRoute53 route53Client, long validationCheckIntervalMillis, long validationDNSEntryTTL) {
        Intrinsics.checkParameterIsNotNull((Object)acmClient, (String)"acmClient");
        Intrinsics.checkParameterIsNotNull((Object)route53Client, (String)"route53Client");
        this.acmClient = acmClient;
        this.route53Client = route53Client;
        this.validationCheckIntervalMillis = validationCheckIntervalMillis;
        this.validationDNSEntryTTL = validationDNSEntryTTL;
    }

    public /* synthetic */ CertificateClient(AWSCertificateManager aWSCertificateManager, AmazonRoute53 amazonRoute53, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = 10000L;
        }
        if ((n & 8) != 0) {
            l2 = 300L;
        }
        this(aWSCertificateManager, amazonRoute53, l, l2);
    }

    public CertificateClient(@NotNull AWSCredentialsProvider credentialsProvider, @NotNull String region) {
        Intrinsics.checkParameterIsNotNull((Object)credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
        Object object = ((AWSCertificateManagerClientBuilder)((AWSCertificateManagerClientBuilder)AWSCertificateManagerClientBuilder.standard().withRegion(region)).withCredentials(credentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"AWSCertificateManagerCli\u2026                 .build()");
        AWSCertificateManager aWSCertificateManager = (AWSCertificateManager)object;
        Object object2 = ((AmazonRoute53ClientBuilder)((AmazonRoute53ClientBuilder)AmazonRoute53ClientBuilder.standard().withRegion(region)).withCredentials(credentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"AmazonRoute53ClientBuild\u2026                 .build()");
        this(aWSCertificateManager, (AmazonRoute53)object2, 0L, 0L, 12, null);
    }
}

