/*
 * Decompiled with CFR 0.152.
 */
package cloud.rio.amazonas;

import cloud.rio.amazonas.AmazonCloudformationClient;
import cloud.rio.amazonas.StackTemplate;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClientBuilder;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DeleteStackResult;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.StackEvent;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J(\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J(\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J \u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J \u0010\"\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcloud/rio/amazonas/AmazonCloudformationClient;", "", "credentialsProvider", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "region", "", "(Lcom/amazonaws/auth/AWSCredentialsProvider;Ljava/lang/String;)V", "amazonCloudFormation", "Lcom/amazonaws/services/cloudformation/AmazonCloudFormation;", "(Lcom/amazonaws/services/cloudformation/AmazonCloudFormation;)V", "createOrUpdateStackAndWait", "", "stackTemplate", "Lcloud/rio/amazonas/StackTemplate;", "capability", "onCreationFailure", "sleepWhileWaitingInSec", "", "createStack", "Lcom/amazonaws/services/cloudformation/model/CreateStackResult;", "createStackAndWait", "cfnOnFailure", "loopWaitInSec", "deleteAndCreate", "deleteStackAndWait", "Lcom/amazonaws/services/cloudformation/model/DeleteStackResult;", "stackName", "findFirstFailingResourceStatuses", "stackId", "loadFile", "templatePath", "updateStack", "Lcom/amazonaws/services/cloudformation/model/UpdateStackResult;", "updateStackAndWait", "waitForStack", "loopWait", "Companion", "amazonas"})
public final class AmazonCloudformationClient {
    private final AmazonCloudFormation amazonCloudFormation;
    private static final List<String> successStackStatuses;
    private static final List<String> waitStackStatuses;
    private static final List<String> stableStackStatuses;
    private static final List<String> failingResourceStatuses;
    private static final int waitingLoopTimeout = 1800;
    private static final Logger LOGGER;
    public static final Companion Companion;

    public final void createOrUpdateStackAndWait(@NotNull StackTemplate stackTemplate, @NotNull String capability, @NotNull String onCreationFailure, int sleepWhileWaitingInSec) {
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)stackTemplate, (String)"stackTemplate");
            Intrinsics.checkParameterIsNotNull((Object)capability, (String)"capability");
            Intrinsics.checkParameterIsNotNull((Object)onCreationFailure, (String)"onCreationFailure");
            try {
                DescribeStacksResult describeStacksResult = this.amazonCloudFormation.describeStacks(new DescribeStacksRequest().withStackName(stackTemplate.getName()));
                Intrinsics.checkExpressionValueIsNotNull((Object)describeStacksResult, (String)"amazonCloudFormation\n   \u2026Name(stackTemplate.name))");
                List list = describeStacksResult.getStacks();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"amazonCloudFormation\n   \u2026                  .stacks");
                Stack stack = (Stack)CollectionsKt.first((List)list);
                Stack stack2 = stack;
                Intrinsics.checkExpressionValueIsNotNull((Object)stack2, (String)"stack");
                if (Intrinsics.areEqual((Object)stack2.getStackStatus(), (Object)"DELETE_COMPLETE")) {
                    this.deleteAndCreate(stackTemplate, capability, onCreationFailure, sleepWhileWaitingInSec);
                    break block8;
                }
                if (stableStackStatuses.contains(stack.getStackStatus())) {
                    this.updateStackAndWait(stackTemplate, capability, sleepWhileWaitingInSec);
                    break block8;
                }
                throw (Throwable)new RuntimeException("Invalid status for update: " + stack.getStackStatus());
            }
            catch (AmazonServiceException e) {
                String string = e.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.message!!");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"does not exist", (boolean)false, (int)2, null)) {
                    this.createStackAndWait(stackTemplate, capability, onCreationFailure, sleepWhileWaitingInSec);
                }
                String string2 = e.getMessage();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"e.message!!");
                if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"No updates are to be performed.", (boolean)false, (int)2, null)) {
                    LOGGER.trace(e.getMessage());
                }
                throw (Throwable)e;
            }
        }
    }

    public static /* synthetic */ void createOrUpdateStackAndWait$default(AmazonCloudformationClient amazonCloudformationClient, StackTemplate stackTemplate, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "CAPABILITY_NAMED_IAM";
        }
        if ((n2 & 4) != 0) {
            string2 = "DELETE";
        }
        if ((n2 & 8) != 0) {
            n = 10;
        }
        amazonCloudformationClient.createOrUpdateStackAndWait(stackTemplate, string, string2, n);
    }

    private final void deleteAndCreate(StackTemplate stackTemplate, String capability, String onCreationFailure, int loopWaitInSec) {
        LOGGER.info("Deleting stack: " + stackTemplate.getName() + " before it can be created.");
        this.deleteStackAndWait(stackTemplate.getName());
        this.createStackAndWait(stackTemplate, capability, onCreationFailure, loopWaitInSec);
    }

    private final void updateStackAndWait(StackTemplate stackTemplate, String capability, int loopWaitInSec) {
        LOGGER.info("Update stack: " + stackTemplate.getName());
        UpdateStackResult updateStackResult = this.updateStack(stackTemplate, capability);
        LOGGER.info("Update requested: " + updateStackResult.getStackId());
        String string = stackTemplate.getName();
        String string2 = updateStackResult.getStackId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"updateStackResult.stackId");
        this.waitForStack(string, string2, loopWaitInSec);
    }

    private final void createStackAndWait(StackTemplate stackTemplate, String capability, String cfnOnFailure, int loopWaitInSec) {
        LOGGER.info("Create stack: " + stackTemplate.getName());
        CreateStackResult createStackResult = this.createStack(stackTemplate, capability, cfnOnFailure);
        LOGGER.info("Create requested: " + createStackResult.getStackId());
        String string = stackTemplate.getName();
        String string2 = createStackResult.getStackId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"createStackResult.stackId");
        this.waitForStack(string, string2, loopWaitInSec);
    }

    /*
     * Unable to fully structure code
     */
    private final DeleteStackResult deleteStackAndWait(String stackName) {
        deleteStackResult = this.amazonCloudFormation.deleteStack(new DeleteStackRequest().withStackName(stackName));
        start = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() > start + (long)1800000) {
                throw (Throwable)new RuntimeException("Timeout");
            }
            try {
                v0 = this.amazonCloudFormation.describeStacks(new DescribeStacksRequest().withStackName(stackName));
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"amazonCloudFormation\n   \u2026withStackName(stackName))");
                v1 = v0.getStacks();
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"amazonCloudFormation\n   \u2026                  .stacks");
                CollectionsKt.first((List)v1);
                continue;
            }
            catch (AmazonServiceException e) {
                v2 = e.getMessage();
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"e.message!!");
                if (StringsKt.contains$default((CharSequence)v2, (CharSequence)"does not exist", (boolean)false, (int)2, null)) ** break;
                continue;
                v3 = deleteStackResult;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"deleteStackResult");
                return v3;
            }
            break;
        }
    }

    private final UpdateStackResult updateStack(StackTemplate stackTemplate, String capability) {
        UpdateStackRequest updateStackRequest = new UpdateStackRequest().withStackName(stackTemplate.getName()).withParameters((Collection)stackTemplate.getParameters()).withTags((Collection)stackTemplate.getTags()).withCapabilities((Collection)CollectionsKt.listOf((Object)capability));
        if (StringsKt.startsWith$default((String)stackTemplate.getTemplatePath(), (String)"http", (boolean)false, (int)2, null)) {
            UpdateStackRequest updateStackRequest2 = updateStackRequest;
            Intrinsics.checkExpressionValueIsNotNull((Object)updateStackRequest2, (String)"updateStackRequest");
            updateStackRequest2.setTemplateURL(stackTemplate.getTemplatePath());
        } else {
            UpdateStackRequest updateStackRequest3 = updateStackRequest;
            Intrinsics.checkExpressionValueIsNotNull((Object)updateStackRequest3, (String)"updateStackRequest");
            updateStackRequest3.setTemplateBody(this.loadFile(stackTemplate.getTemplatePath()));
        }
        UpdateStackResult updateStackResult = this.amazonCloudFormation.updateStack(updateStackRequest);
        Intrinsics.checkExpressionValueIsNotNull((Object)updateStackResult, (String)"amazonCloudFormation.upd\u2026Stack(updateStackRequest)");
        return updateStackResult;
    }

    private final CreateStackResult createStack(StackTemplate stackTemplate, String capability, String onCreationFailure) {
        CreateStackRequest createStackRequest = new CreateStackRequest().withStackName(stackTemplate.getName()).withParameters((Collection)stackTemplate.getParameters()).withTags((Collection)stackTemplate.getTags()).withOnFailure(onCreationFailure).withCapabilities((Collection)CollectionsKt.listOf((Object)capability));
        if (StringsKt.startsWith$default((String)stackTemplate.getTemplatePath(), (String)"http", (boolean)false, (int)2, null)) {
            CreateStackRequest createStackRequest2 = createStackRequest;
            Intrinsics.checkExpressionValueIsNotNull((Object)createStackRequest2, (String)"createStackRequest");
            createStackRequest2.setTemplateURL(stackTemplate.getTemplatePath());
        } else {
            CreateStackRequest createStackRequest3 = createStackRequest;
            Intrinsics.checkExpressionValueIsNotNull((Object)createStackRequest3, (String)"createStackRequest");
            createStackRequest3.setTemplateBody(this.loadFile(stackTemplate.getTemplatePath()));
        }
        CreateStackResult createStackResult = this.amazonCloudFormation.createStack(createStackRequest);
        Intrinsics.checkExpressionValueIsNotNull((Object)createStackResult, (String)"amazonCloudFormation.cre\u2026Stack(createStackRequest)");
        return createStackResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void waitForStack(String stackName, String stackId, int loopWait) {
        long start = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() > start + (long)1800000) {
                throw (Throwable)new RuntimeException("Timeout");
            }
            try {
                Stack stack;
                DescribeStacksResult describeStacksResult = this.amazonCloudFormation.describeStacks(new DescribeStacksRequest().withStackName(stackName));
                Intrinsics.checkExpressionValueIsNotNull((Object)describeStacksResult, (String)"amazonCloudFormation\n   \u2026withStackName(stackName))");
                List list = describeStacksResult.getStacks();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"amazonCloudFormation\n   \u2026                  .stacks");
                if ((Stack)CollectionsKt.first((List)list) == null) {
                    throw (Throwable)new RuntimeException("The stack " + stackName + " does not exist");
                }
                String status = stack.getStackStatus();
                if (successStackStatuses.contains(status)) {
                    LOGGER.info("Status of stack " + stackName + " is " + status + '.');
                    AmazonCloudformationClient.Companion.printStackOutputs(stack);
                    break;
                }
                if (!waitStackStatuses.contains(status)) {
                    this.findFirstFailingResourceStatuses(stackName, stackId);
                    throw (Throwable)new RuntimeException("Status of stack " + stackName + " is " + status + ". It seems to be failed!");
                }
                LOGGER.info("Status of stack " + stackName + " is " + status + "...");
                Thread.sleep(loopWait * 1000);
            }
            catch (AmazonServiceException e) {
                this.findFirstFailingResourceStatuses(stackName, stackId);
                throw (Throwable)new RuntimeException("Waiting for stack " + stackName + " failed!");
            }
        }
        this.findFirstFailingResourceStatuses(stackName, stackId);
    }

    private final String loadFile(String templatePath) {
        try {
            String string = FileUtils.readFileToString((File)new File(templatePath));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtils.readFileToString(File(templatePath))");
            return string;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("Could not read TemplateFile.", e);
        }
    }

    private final void findFirstFailingResourceStatuses(String stackName, String stackId) {
        Object v4;
        block3: {
            DescribeStackEventsResult describeStackEventsResult = this.amazonCloudFormation.describeStackEvents(new DescribeStackEventsRequest().withStackName(stackId));
            Intrinsics.checkExpressionValueIsNotNull((Object)describeStackEventsResult, (String)"amazonCloudFormation\n   \u2026).withStackName(stackId))");
            List list = describeStackEventsResult.getStackEvents();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"amazonCloudFormation\n   \u2026             .stackEvents");
            Iterable $this$sortedByDescending$iv = list;
            boolean $i$f$sortedByDescending = false;
            Iterable iterable = $this$sortedByDescending$iv;
            boolean bl = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    StackEvent it = (StackEvent)b;
                    boolean bl2 = false;
                    StackEvent stackEvent = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)stackEvent, (String)"it");
                    it = (StackEvent)a;
                    Comparable comparable = stackEvent.getTimestamp();
                    bl2 = false;
                    StackEvent stackEvent2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)stackEvent2, (String)"it");
                    Date date = stackEvent2.getTimestamp();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)date);
                }
            };
            Iterable $this$takeWhile$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                StackEvent it = (StackEvent)item$iv;
                boolean bl2 = false;
                StackEvent stackEvent = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)stackEvent, (String)"it");
                if (!(Intrinsics.areEqual((Object)stackEvent.getResourceStatus(), (Object)"UPDATE_IN_PROGRESS") ^ true)) break;
                list$iv.add(item$iv);
            }
            List $this$lastOrNull$iv = list$iv;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                StackEvent it = (StackEvent)element$iv;
                boolean bl3 = false;
                StackEvent stackEvent = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)stackEvent, (String)"it");
                if (!failingResourceStatuses.contains(stackEvent.getResourceStatus())) continue;
                v4 = element$iv;
                break block3;
            }
            v4 = null;
        }
        StackEvent stackEvent = v4;
        if (stackEvent != null) {
            throw (Throwable)new RuntimeException("Status of stack " + stackName + " was " + stackEvent.getResourceStatus() + ". Reason: " + stackEvent.getResourceStatusReason());
        }
    }

    public AmazonCloudformationClient(@NotNull AmazonCloudFormation amazonCloudFormation) {
        Intrinsics.checkParameterIsNotNull((Object)amazonCloudFormation, (String)"amazonCloudFormation");
        this.amazonCloudFormation = amazonCloudFormation;
    }

    public AmazonCloudformationClient(@NotNull AWSCredentialsProvider credentialsProvider, @NotNull String region) {
        Intrinsics.checkParameterIsNotNull((Object)credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
        Object object = ((AmazonCloudFormationClientBuilder)((AmazonCloudFormationClientBuilder)AmazonCloudFormationClientBuilder.standard().withRegion(region)).withCredentials(credentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"AmazonCloudFormationClie\u2026                 .build()");
        this((AmazonCloudFormation)object);
    }

    static {
        Companion = new Companion(null);
        successStackStatuses = CollectionsKt.listOf((Object[])new String[]{"CREATE_COMPLETE", "UPDATE_COMPLETE", "DELETE_COMPLETE"});
        waitStackStatuses = CollectionsKt.listOf((Object[])new String[]{"CREATE_IN_PROGRESS", "ROLLBACK_IN_PROGRESS", "DELETE_IN_PROGRESS", "UPDATE_IN_PROGRESS", "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS", "UPDATE_ROLLBACK_IN_PROGRESS", "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS"});
        stableStackStatuses = CollectionsKt.listOf((Object[])new String[]{"CREATE_COMPLETE", "ROLLBACK_COMPLETE", "UPDATE_COMPLETE", "UPDATE_ROLLBACK_COMPLETE"});
        failingResourceStatuses = CollectionsKt.listOf((Object[])new String[]{"CREATE_FAILED", "UPDATE_FAILED", "DELETE_FAILED"});
        LOGGER = LogManager.getLogger(AmazonCloudformationClient.class);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcloud/rio/amazonas/AmazonCloudformationClient$Companion;", "", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "failingResourceStatuses", "", "", "stableStackStatuses", "successStackStatuses", "waitStackStatuses", "waitingLoopTimeout", "", "printStackOutputs", "", "stack", "Lcom/amazonaws/services/cloudformation/model/Stack;", "amazonas"})
    public static final class Companion {
        private final void printStackOutputs(Stack stack) {
            LOGGER.info("==== Outputs ====");
            if (stack.getOutputs().size() > 0) {
                stack.getOutputs().stream().forEach(printStackOutputs.1.INSTANCE);
            } else {
                LOGGER.info("No outputs!");
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

