package cloud.prefab.client;

import cloud.prefab.client.util.MemcachedCache;
import cloud.prefab.domain.Prefab;
import com.google.common.collect.Lists;
import net.spy.memcached.MemcachedClient;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.Executors;

public class Tester {

  public static void main(String[] args) throws InterruptedException, IOException {

    net.spy.memcached.MemcachedClient memcachedClient = new net.spy.memcached.MemcachedClient(
        new InetSocketAddress("localhost", 11211));

    final RateLimitClient rateLimitClient = getLocalRateLimitClient(memcachedClient);


//    testRateLimits(rateLimitClient);

//    testConfig(prefabCloudClient, rateLimitClient);

    test();
  }


  private static void test() throws InterruptedException {
//    PrefabCloudClient.Builder builder = new PrefabCloudClient.Builder()
//        .setNamespace("foo")
////        .setApikey("50|99562dc4f19055d45551b7d2796074db");
//        .setTarget("api.staging-prefab.cloud")
////        .setApikey("1|9991234jhlkk3");
//        .setApikey("5|2aa22ea150f401a6557c55329723fa20");


    PrefabCloudClient.Builder builder = new PrefabCloudClient.Builder()
        .setNamespace("foo")
        .setApikey("50|99562dc4f19055d45551b7d2796074db");
//        .setTarget("localhost:8084")
//        .setSsl(false)
//        .setApikey("1|asdfjklhsfljk");


    final PrefabCloudClient prefabCloudClient = new PrefabCloudClient(builder);
//    testRateLimits(prefabCloudClient);

//    testConfig(prefabCloudClient, prefabCloudClient.rateLimitClient());
    testActual(prefabCloudClient);
  }

  private static void testActual(PrefabCloudClient prefabCloudClient) {
    final RateLimitClient rateLimitClient = prefabCloudClient.rateLimitClient();
    for (int i = 0; i < 10; ++i) {
      final boolean result = rateLimitClient.acquire(
          Prefab.LimitRequest.newBuilder().setAcquireAmount(1).addGroups("googleTranscriptionApi")
              .build(), Prefab.OnFailure.THROW).getPassed();

      System.out.println("acquire? " + result);
    }
  }

  private static void testRateLimits(PrefabCloudClient prefabCloudClient) {
    final RateLimitClient rateLimitClient = prefabCloudClient.rateLimitClient();
    for (int i = 0; i < 100; ++i) {
      final boolean result = rateLimitClient.acquire(
//          Prefab.LimitRequest.newBuilder().setAcquireAmount(1).addGroups("googleTranscriptionApi")
          Prefab.LimitRequest.newBuilder().setAcquireAmount(1).addGroups("2_per_sec")
//          Prefab.LimitRequest.newBuilder().setAcquireAmount(1).addGroups("2_per_min")
              .build(), Prefab.OnFailure.THROW).getPassed();

      System.out.println("acquire? " + result);
    }
  }


  private static RateLimitClient getLocalRateLimitClient(MemcachedClient memcachedClient) {
    PrefabCloudClient.Builder builder = new PrefabCloudClient.Builder()
        .setNamespace("foo")
        .setDistributedCache(new MemcachedCache(memcachedClient))
        .setLocal(true);


    final PrefabCloudClient prefabCloudClient = new PrefabCloudClient(builder);

    return prefabCloudClient.rateLimitClient();
  }

  private static void testRateLimits(RateLimitClient rateLimitClient, ConfigClient configClient) throws InterruptedException {


    configClient.upsert("hubtest.secondly", Prefab.ConfigValue.newBuilder()
        .setLimitDefinition(Prefab.LimitDefinition.newBuilder()
            .setLimit(1)
            .setPolicyName(Prefab.LimitResponse.LimitPolicyNames.SECONDLY_ROLLING)
            .build())
        .build());

    for (int i = 0; i < 40; i++) {

      boolean result = rateLimitClient.isPass(Prefab.LimitRequest.newBuilder()
          .setAcquireAmount(1)
          .addGroups("hubtest.secondly")
          .build());
      Thread.sleep(100);
      System.out.println("acquire? " + result);
    }
  }

  private static void testConfig(PrefabCloudClient prefabCloudClient, RateLimitClient rateLimitClient) throws InterruptedException {
    final ConfigClient configClient = prefabCloudClient.configClient();
//
//    configClient.upsert(Prefab.UpsertRequest.newBuilder()
//        .setConfigDelta(Prefab.ConfigDelta.newBuilder()
//            .setKey("example")
//            .setValue(Prefab.ConfigValue.newBuilder()
//                .setInt(1)
//                .build())
//            .build())
//        .build(), configValue);

    configClient.upsert("example", Prefab.ConfigValue.newBuilder()
        .setInt(1)
        .build());

    configClient.get("example"); //returns 1

    Executors.newFixedThreadPool(1).submit(new Runnable() {
      @Override
      public void run() {
        for (int i = 0; i < 100; i++) {

          final long value = (long) (Math.random() * 10);
          System.out.println("set to " + value);
          configClient.upsert("A", Prefab.ConfigValue.newBuilder()
              .setInt(value)
              .build());
          try {
            Thread.sleep(2000);
          } catch (InterruptedException e) {
            e.printStackTrace();
          }
        }
      }
    });


    final FeatureFlagClient featureFlagClient = prefabCloudClient.featureFlagClient();

    configClient.upsert("hourlytask", Prefab.ConfigValue.newBuilder()
        .setLimitDefinition(Prefab.LimitDefinition.newBuilder()
            .setLimit(1)
            .setPolicyName(Prefab.LimitResponse.LimitPolicyNames.HOURLY_ROLLING)
            .build())
        .build());
//      System.out.println("feature is on" + featureFlagClient.featureIsOn("A"));

    for (int i = 0; i < 100; i++) {
      System.out.println("Value is " + configClient.get("A"));
      Thread.sleep(3000);
    }

//    Value<Integer> vv = foo.getLive(Integer, "a");

    configClient.upsert("MyFeature", Prefab.ConfigValue.newBuilder()
        .setFeatureFlag(Prefab.FeatureFlag.newBuilder()
            .setPct(0.1)
            .addWhitelisted("betas")
            .addWhitelisted("user:1")
            .build()).build());

    //Create a flag that is on for 10 % of traffic, the entire beta group and user:
    featureFlagClient.upsert("MyFeature", Prefab.FeatureFlag.newBuilder()
        .setPct(0.1)
        .addWhitelisted("betas")
        .addWhitelisted("user:1")
        .build());


    //returns yes 10 pct of the time
    System.out.println(featureFlagClient.featureIsOn("MyFeature"));

    //A single user should get the same result each time
    //with 10 % probability user1123 will return yes, and if they do they always will
    System.out.println(featureFlagClient.featureIsOnFor("MyFeature", Optional.of("user:1123"), Lists.newArrayList()));

    //Utilize the whitelisted attributes to easily feature flag groups of people
    System.out.println(featureFlagClient.featureIsOnFor("MyFeature", Optional.of("user:234"), Lists.newArrayList("betas")));
  }
}
