package cloud.prefab.client;

import cloud.prefab.client.util.MemcachedCache;
import cloud.prefab.domain.Prefab;
import com.google.common.collect.Lists;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;

public class Tester {

  public static void main(String[] args) throws InterruptedException, IOException {

    net.spy.memcached.MemcachedClient memcachedClient = new net.spy.memcached.MemcachedClient(
        new InetSocketAddress("localhost", 11211));

    PrefabCloudClient.Builder builder = new PrefabCloudClient.Builder()
        .setNamespace("foo")
        .setDistributedCache(new MemcachedCache(memcachedClient))
        .setLocal(true);


    final PrefabCloudClient prefabCloudClient = new PrefabCloudClient(builder);

    final RateLimitClient rateLimitClient = prefabCloudClient.rateLimitClient();


    testRateLimits(rateLimitClient);

//    testConfig(prefabCloudClient, rateLimitClient);


  }

  private static void testRateLimits(RateLimitClient rateLimitClient) throws InterruptedException {

    rateLimitClient.upsert(Prefab.LimitDefinition.newBuilder()
        .setLimit(1)
        .setPolicyName(Prefab.LimitResponse.LimitPolicyNames.SECONDLY_ROLLING)
        .setGroup("hubtest.secondly")
        .build());
    for (int i = 0; i < 40; i++) {

      boolean result = rateLimitClient.isPass(Prefab.LimitRequest.newBuilder()
          .setAcquireAmount(1)
          .addGroups("hubtest.secondly")
          .build());
      Thread.sleep(100);
      System.out.println("acquire? " + result);
    }
  }

  private static void testConfig(PrefabCloudClient prefabCloudClient, RateLimitClient rateLimitClient) throws InterruptedException {
    final ConfigClient configClient = prefabCloudClient.configClient();
//
//    configClient.upsert(Prefab.UpsertRequest.newBuilder()
//        .setConfigDelta(Prefab.ConfigDelta.newBuilder()
//            .setKey("example")
//            .setValue(Prefab.ConfigValue.newBuilder()
//                .setInt(1)
//                .build())
//            .build())
//        .build(), configValue);

    configClient.upsert("example", Prefab.ConfigValue.newBuilder()
        .setInt(1)
        .build());

    configClient.get("example"); //returns 1


    final FeatureFlagClient featureFlagClient = prefabCloudClient.featureFlagClient();


    rateLimitClient.upsert(Prefab.LimitDefinition.newBuilder()
        .setGroup("hourlytask")
        .setLimit(1)
        .setPolicyName(Prefab.LimitResponse.LimitPolicyNames.HOURLY_ROLLING)
        .build());

    for (int i = 0; i < 100; i++) {
      System.out.println("feature is on" + featureFlagClient.featureIsOn("A"));
      Thread.sleep(3000);
    }

//    Value<Integer> vv = foo.getLive(Integer, "a");

    configClient.upsert("MyFeature", Prefab.ConfigValue.newBuilder()
                .setFeatureFlag(Prefab.FeatureFlag.newBuilder()
                    .setPct(0.1)
                    .addWhitelisted("betas")
                    .addWhitelisted("user:1")
                    .build()).build());

    //Create a flag that is on for 10 % of traffic, the entire beta group and user:
    featureFlagClient.upsert("MyFeature", Prefab.FeatureFlag.newBuilder()
        .setPct(0.1)
        .addWhitelisted("betas")
        .addWhitelisted("user:1")
        .build());


    //returns yes 10 pct of the time
    System.out.println(featureFlagClient.featureIsOn("MyFeature"));

    //A single user should get the same result each time
    //with 10 % probability user1123 will return yes, and if they do they always will
    System.out.println(featureFlagClient.featureIsOnFor("MyFeature", Optional.of("user:1123"), Lists.newArrayList()));

    //Utilize the whitelisted attributes to easily feature flag groups of people
    System.out.println(featureFlagClient.featureIsOnFor("MyFeature", Optional.of("user:234"), Lists.newArrayList("betas")));
  }
}
