package cloud.prefab.client;

import cloud.prefab.domain.Prefab;

public class Tester {

  public static void main(String[] args) throws InterruptedException {
    PrefabCloudClient.Builder builder = new PrefabCloudClient.Builder()
        .setNamespace("foo")
        .setLocal(true);
    final PrefabCloudClient prefabCloudClient = new PrefabCloudClient(builder);

    final RateLimitClient rateLimitClient = prefabCloudClient.newRateLimitClient();


    for (int i = 0; i < 20; i++) {

      boolean result = rateLimitClient.isPass(Prefab.LimitRequest.newBuilder()
          .setAcquireAmount(1)
          .addGroups("hubtest.secondly")
          .build());
      System.out.println("acquire? " + result);
    }

    final ConfigClient foo = prefabCloudClient.newConfigClient();
    System.out.println(foo.getLiveConfig().getString("a"));


    final FeatureFlagClient featureFlagClient = prefabCloudClient.newFeatureFlagClient();


    System.out.println(featureFlagClient.featureIsOn("A"));


    Thread.sleep(3000);

  }
}
