/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.session.hazelcast;

import cloud.piranha.api.HttpSessionManager;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class HazelcastHttpSession
implements HttpSession,
Serializable {
    private HashMap<String, Object> attributes = new HashMap();
    private long creationTime;
    private String id;
    private long lastAccessedTime;
    private int maxInactiveInterval;
    private boolean newFlag;
    private transient ServletContext servletContext;
    private transient HttpSessionManager sessionManager;
    private boolean valid;

    public HazelcastHttpSession() {
    }

    public HazelcastHttpSession(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.creationTime = System.currentTimeMillis();
        this.lastAccessedTime = System.currentTimeMillis();
        this.valid = true;
    }

    public HazelcastHttpSession(ServletContext servletContext, String id, boolean newFlag) {
        this.servletContext = servletContext;
        this.id = id;
        this.newFlag = newFlag;
        this.creationTime = System.currentTimeMillis();
        this.lastAccessedTime = System.currentTimeMillis();
        this.valid = true;
    }

    public Object getAttribute(String name) {
        this.verifyValid("getAttribute");
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.verifyValid("getAttributeNames");
        return Collections.enumeration(this.attributes.keySet());
    }

    public long getCreationTime() {
        this.verifyValid("getCreationTime");
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        this.verifyValid("getLastAccessedTime");
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        this.verifyValid("getValueNames");
        return this.attributes.keySet().toArray(new String[0]);
    }

    public void invalidate() {
        this.verifyValid("invalidate");
        this.valid = false;
    }

    public boolean isNew() {
        this.verifyValid("isNew");
        return this.newFlag;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.verifyValid("removeAttribute");
        this.attributes.remove(name);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.verifyValid("setAttribute");
        if (value != null) {
            boolean added = true;
            if (this.attributes.containsKey(name)) {
                added = false;
            }
            this.attributes.put(name, value);
            if (added) {
                this.sessionManager.attributeAdded((HttpSession)this, name, value);
            } else {
                this.sessionManager.attributeReplaced((HttpSession)this, name, value);
            }
        } else {
            this.removeAttribute(name);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public void setNew(boolean newFlag) {
        this.verifyValid("setNew");
        this.newFlag = newFlag;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setSessionManager(HttpSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    private void verifyValid(String methodName) {
        if (!this.valid) {
            throw new IllegalStateException("Session is invalid, called by: " + methodName);
        }
    }
}

