/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.session.hazelcast;

import cloud.piranha.DefaultHttpSessionManager;
import cloud.piranha.api.HttpSessionManager;
import cloud.piranha.api.WebApplication;
import cloud.piranha.session.hazelcast.HazelcastHttpSession;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

public class HazelcastHttpSessionManager
extends DefaultHttpSessionManager {
    private HazelcastInstance hazelcast;

    public HazelcastHttpSessionManager() {
        this(HazelcastHttpSessionManager.class.getName());
    }

    public HazelcastHttpSessionManager(String name) {
        Config config = new Config();
        config.setInstanceName(name);
        this.hazelcast = Hazelcast.newHazelcastInstance();
        this.sessions = this.hazelcast.getMap(name);
    }

    public String changeSessionId(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        String key = null;
        if (session == null) {
            throw new IllegalStateException("No session active");
        }
        String oldSessionId = session.getId();
        this.sessions.remove(oldSessionId);
        key = UUID.randomUUID().toString();
        HazelcastHttpSession newSession = (HazelcastHttpSession)session;
        newSession.setId(key);
        this.sessions.put(key, (HazelcastHttpSession)session);
        this.idListeners.stream().forEach(idListener -> idListener.sessionIdChanged(new HttpSessionEvent(session), oldSessionId));
        return key;
    }

    public synchronized HttpSession createSession(WebApplication webApplication, HttpServletRequest request) {
        String key = UUID.randomUUID().toString();
        while (this.sessions.containsKey(key)) {
            key = UUID.randomUUID().toString();
        }
        HazelcastHttpSession result = new HazelcastHttpSession((ServletContext)webApplication, key, true);
        result.setSessionManager((HttpSessionManager)this);
        this.sessions.put(key, result);
        HttpServletResponse response = (HttpServletResponse)webApplication.getResponse((ServletRequest)request);
        Cookie cookie = new Cookie(this.name, key);
        response.addCookie(cookie);
        this.sessionListeners.stream().forEach(sessionListener -> sessionListener.sessionCreated(new HttpSessionEvent((HttpSession)result)));
        return result;
    }

    public HttpSession getSession(WebApplication webApplication, HttpServletRequest request, String currentSessionId) {
        HttpServletResponse response = (HttpServletResponse)webApplication.getResponse((ServletRequest)request);
        HazelcastHttpSession result = (HazelcastHttpSession)this.sessions.get(currentSessionId);
        result.setSessionManager((HttpSessionManager)this);
        result.setServletContext((ServletContext)webApplication);
        Cookie cookie = new Cookie(this.name, currentSessionId);
        response.addCookie(cookie);
        result.setNew(false);
        return result;
    }
}

