/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.resource.shrinkwrap;

import cloud.piranha.api.Resource;
import cloud.piranha.resource.shrinkwrap.ArchiveURLStreamHandler;
import cloud.piranha.resource.shrinkwrap.NodeURLStreamHandler;
import cloud.piranha.resource.shrinkwrap.ShrinkWrapDirectoryInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Collection;
import java.util.stream.Stream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class ShrinkWrapResource
implements Resource {
    private Archive<?> archive;
    private ArchiveURLStreamHandler archiveStreamHandler;

    public ShrinkWrapResource(String resourcesPath, Archive<?> archive) {
        JavaArchive newArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        this.getAllLocations(archive).filter(path -> path.startsWith(resourcesPath)).forEach(path -> {
            JavaArchive cfr_ignored_0 = (JavaArchive)newArchive.add(archive.get(path).getAsset(), path.substring(resourcesPath.length()));
        });
        this.archive = newArchive;
        this.archiveStreamHandler = new ArchiveURLStreamHandler(this.archive);
    }

    public ShrinkWrapResource(Archive<?> archive) {
        this.archive = archive.shallowCopy();
        this.archiveStreamHandler = new ArchiveURLStreamHandler(this.archive);
    }

    public URL getResource(String url) {
        String location = this.getLocationFromUrl(url);
        if (location == null) {
            return null;
        }
        Node node = this.getNode(this.archive, location);
        if (node == null) {
            return null;
        }
        URLStreamHandler streamHandler = this.archiveStreamHandler;
        Asset asset = node.getAsset();
        if (asset == null) {
            streamHandler = new NodeURLStreamHandler(this.getContentFromNode(node));
        }
        try {
            return new URL(null, "shrinkwrap://" + this.archive.getName() + (location.startsWith("/") ? "" : (this.archive.getName().endsWith("/") ? "" : "/")) + location, streamHandler);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public InputStream getResourceAsStream(String url) {
        String location = this.getLocationFromUrl(url);
        if (location == null) {
            return null;
        }
        Node node = this.getNode(this.archive, location);
        if (node == null) {
            return null;
        }
        Asset asset = node.getAsset();
        if (asset == null) {
            return new ShrinkWrapDirectoryInputStream(this.getContentFromNode(node));
        }
        return asset.openStream();
    }

    public Stream<String> getAllLocations() {
        return this.getAllLocations(this.archive);
    }

    public Stream<String> getAllLocations(Archive<?> archiveToGetFrom) {
        return archiveToGetFrom.getContent().keySet().stream().map(e -> e.get()).filter(e -> this.getAsset(archiveToGetFrom, (String)e) != null);
    }

    private Collection<Node> getContentFromNode(Node node) {
        return this.archive.getContent(e -> e.get().startsWith(node.getPath().get())).values();
    }

    private String getLocationFromUrl(String url) {
        if (url == null) {
            return null;
        }
        if (!url.contains("shrinkwrap://")) {
            return url;
        }
        try {
            String cleanedUrl = url.replace("cloud/piranha/shrinkwrap://", "shrinkwrap://");
            URL archiveURL = new URL(cleanedUrl);
            String archiveName = archiveURL.getHost();
            if (!this.archive.getName().equals(archiveName)) {
                return null;
            }
            return archiveURL.getPath().replace("//", "/");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    private Asset getAsset(Archive<?> archiveToGetFrom, String location) {
        Node node = this.getNode(archiveToGetFrom, location);
        if (node == null) {
            return null;
        }
        Asset asset = node.getAsset();
        if (asset == null) {
            return null;
        }
        return asset;
    }

    private Node getNode(Archive<?> archiveToGetFrom, String location) {
        return archiveToGetFrom.get(ArchivePaths.create((String)location));
    }
}

