/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.embedded;

import cloud.piranha.DefaultWebApplication;
import cloud.piranha.api.WebApplication;
import cloud.piranha.embedded.EmbeddedRequest;
import cloud.piranha.embedded.EmbeddedResponse;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class EmbeddedPiranha {
    private final DefaultWebApplication webApplication = new DefaultWebApplication();

    public WebApplication getWebApplication() {
        return this.webApplication;
    }

    public EmbeddedPiranha initialize() {
        this.webApplication.initialize();
        return this;
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        if (servletRequest.getServletContext() == null && servletRequest instanceof EmbeddedRequest) {
            EmbeddedRequest embeddedRequest = (EmbeddedRequest)servletRequest;
            embeddedRequest.setWebApplication((WebApplication)this.webApplication);
        }
        if (servletResponse instanceof EmbeddedResponse) {
            EmbeddedResponse embeddedResponse = (EmbeddedResponse)servletResponse;
            embeddedResponse.setWebApplication((WebApplication)this.webApplication);
        }
        this.webApplication.linkRequestAndResponse(servletRequest, servletResponse);
        this.webApplication.service(servletRequest, servletResponse);
        this.webApplication.unlinkRequestAndResponse(servletRequest, servletResponse);
    }

    public EmbeddedPiranha start() {
        this.webApplication.start();
        return this;
    }

    public EmbeddedPiranha stop() {
        this.webApplication.stop();
        return this;
    }

    public EmbeddedPiranha destroy() {
        this.webApplication.destroy();
        return this;
    }
}

