/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.embedded;

import cloud.piranha.api.WebApplication;
import cloud.piranha.embedded.EmbeddedRequest;
import javax.servlet.http.Cookie;

public class EmbeddedRequestBuilder {
    private final EmbeddedRequest request = new EmbeddedRequest();

    public EmbeddedRequestBuilder attribute(String name, Object value) {
        this.request.setAttribute(name, value);
        return this;
    }

    public EmbeddedRequest build() {
        return this.request;
    }

    public EmbeddedRequestBuilder contextPath(String contextPath) {
        this.request.setContextPath(contextPath);
        return this;
    }

    public EmbeddedRequestBuilder cookie(Cookie cookie) {
        Cookie[] cookies;
        if (this.request.getCookies() != null) {
            cookies = new Cookie[this.request.getCookies().length + 1];
            for (int i = 0; i < cookies.length - 1; ++i) {
                cookies[i] = (Cookie)cookies[i].clone();
            }
            cookies[cookies.length - 1] = cookie;
        } else {
            cookies = new Cookie[]{cookie};
        }
        this.request.setCookies(cookies);
        return this;
    }

    public EmbeddedRequestBuilder header(String name, String value) {
        this.request.setHeader(name, value);
        return this;
    }

    public EmbeddedRequestBuilder method(String method) {
        this.request.setMethod(method);
        return this;
    }

    public EmbeddedRequestBuilder parameter(String name, String ... values) {
        this.request.setParameter(name, values);
        return this;
    }

    public EmbeddedRequestBuilder pathInfo(String pathInfo) {
        this.request.setPathInfo(pathInfo);
        return this;
    }

    public EmbeddedRequestBuilder requestedSessionId(String requestedSessionId) {
        this.request.setRequestedSessionId(requestedSessionId);
        return this;
    }

    public EmbeddedRequestBuilder requestedSessionIdFromCookie(boolean requestedSessionIdFromCookie) {
        this.request.setRequestedSessionIdFromCookie(requestedSessionIdFromCookie);
        return this;
    }

    public EmbeddedRequestBuilder scheme(String scheme) {
        this.request.setScheme(scheme);
        return this;
    }

    public EmbeddedRequestBuilder servletPath(String servletPath) {
        this.request.setServletPath(servletPath);
        return this;
    }

    public EmbeddedRequestBuilder webApplication(WebApplication webApp) {
        this.request.setWebApplication(webApp);
        return this;
    }
}

