/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.embedded;

import cloud.piranha.DefaultAliasedDirectoryResource;
import cloud.piranha.DefaultDirectoryResource;
import cloud.piranha.api.HttpSessionManager;
import cloud.piranha.api.Resource;
import cloud.piranha.api.WebApplication;
import cloud.piranha.embedded.EmbeddedPiranha;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletRegistration;

public class EmbeddedPiranhaBuilder {
    private final LinkedHashMap<String, Object> attributes = new LinkedHashMap();
    private final ArrayList<String> features = new ArrayList();
    private final ArrayList<String> initializers;
    private final LinkedHashMap<String, String> filters = new LinkedHashMap();
    private final LinkedHashMap<String, HashMap<String, String>> filterInitParameters = new LinkedHashMap();
    private final LinkedHashMap<String, List<String>> filterMappings = new LinkedHashMap();
    private HttpSessionManager httpSessionManager;
    private final ArrayList<Resource> resources;
    private final LinkedHashMap<String, String> servlets;
    private final LinkedHashMap<String, HashMap<String, String>> servletInitParameters;
    private final LinkedHashMap<String, List<String>> servletMappings;

    public EmbeddedPiranhaBuilder() {
        this.initializers = new ArrayList();
        this.resources = new ArrayList();
        this.servlets = new LinkedHashMap();
        this.servletInitParameters = new LinkedHashMap();
        this.servletMappings = new LinkedHashMap();
    }

    public EmbeddedPiranhaBuilder aliasedDirectoryResource(String path, String alias) {
        this.resources.add((Resource)new DefaultAliasedDirectoryResource(new File(path), alias));
        return this;
    }

    public EmbeddedPiranhaBuilder attribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public EmbeddedPiranha build() {
        EmbeddedPiranha piranha = new EmbeddedPiranha();
        WebApplication webApplication = piranha.getWebApplication();
        if (this.httpSessionManager != null) {
            webApplication.setHttpSessionManager(this.httpSessionManager);
        }
        this.attributes.entrySet().forEach(attribute -> {
            String attributeName = (String)attribute.getKey();
            Object attributeValue = attribute.getValue();
            webApplication.setAttribute(attributeName, attributeValue);
        });
        this.resources.forEach(resource -> webApplication.addResource(resource));
        this.features.forEach(feature -> webApplication.addFeature(feature));
        webApplication.initializeFeatures();
        this.initializers.forEach(initializer -> webApplication.addInitializer(initializer));
        webApplication.initializeInitializers();
        this.filters.entrySet().forEach(entry -> {
            String filterName = (String)entry.getKey();
            String className = (String)entry.getValue();
            FilterRegistration.Dynamic filter = webApplication.addFilter(filterName, className);
            HashMap<String, String> initParameters = this.filterInitParameters.get(filterName);
            if (initParameters != null) {
                initParameters.entrySet().forEach(initParameter -> {
                    String name = (String)initParameter.getKey();
                    String value = (String)initParameter.getValue();
                    filter.setInitParameter(name, value);
                });
            }
        });
        this.filterMappings.entrySet().forEach(filterMapping -> {
            String filterName = (String)filterMapping.getKey();
            List urlPatterns = (List)filterMapping.getValue();
            webApplication.addFilterMapping(filterName, urlPatterns.toArray(new String[0]));
        });
        webApplication.initializeFilters();
        this.servlets.entrySet().forEach(entry -> {
            String servletName = (String)entry.getKey();
            String className = (String)entry.getValue();
            ServletRegistration.Dynamic servlet = webApplication.addServlet(servletName, className);
            HashMap<String, String> initParameters = this.servletInitParameters.get(servletName);
            if (initParameters != null) {
                initParameters.entrySet().forEach(initParameter -> {
                    String name = (String)initParameter.getKey();
                    String value = (String)initParameter.getValue();
                    servlet.setInitParameter(name, value);
                });
            }
        });
        this.servletMappings.entrySet().forEach(servetMapping -> {
            String servletName = (String)servetMapping.getKey();
            List urlPatterns = (List)servetMapping.getValue();
            webApplication.addServletMapping(servletName, urlPatterns.toArray(new String[0]));
        });
        webApplication.initializeServlets();
        webApplication.initializeFinish();
        return piranha;
    }

    public EmbeddedPiranha buildAndStart() {
        return this.build().start();
    }

    public EmbeddedPiranhaBuilder directoryResource(String path) {
        this.resources.add((Resource)new DefaultDirectoryResource(path));
        return this;
    }

    public EmbeddedPiranhaBuilder feature(String className) {
        this.features.add(className);
        return this;
    }

    public EmbeddedPiranhaBuilder filter(String filterName, String className) {
        this.filters.put(filterName, className);
        return this;
    }

    public EmbeddedPiranhaBuilder filterInitParam(String filterName, String name, String value) {
        HashMap<String, String> initParameters = this.filterInitParameters.get(filterName);
        if (initParameters == null) {
            initParameters = new HashMap();
            this.filterInitParameters.put(filterName, initParameters);
        }
        initParameters.put(name, value);
        return this;
    }

    public EmbeddedPiranhaBuilder filterMapping(String filterName, String ... urlPatterns) {
        this.filterMappings.put(filterName, Arrays.asList(urlPatterns));
        return this;
    }

    public EmbeddedPiranhaBuilder httpSessionManager(HttpSessionManager httpSessionManager) {
        this.httpSessionManager = httpSessionManager;
        return this;
    }

    public EmbeddedPiranhaBuilder initializer(String className) {
        this.initializers.add(className);
        return this;
    }

    public EmbeddedPiranhaBuilder servlet(String servletName, String className) {
        this.servlets.put(servletName, className);
        return this;
    }

    public EmbeddedPiranhaBuilder servletInitParam(String servletName, String name, String value) {
        HashMap<String, String> initParameters = this.servletInitParameters.get(servletName);
        if (initParameters == null) {
            initParameters = new HashMap();
            this.servletInitParameters.put(servletName, initParameters);
        }
        initParameters.put(name, value);
        return this;
    }

    public EmbeddedPiranhaBuilder servletMapping(String servletName, String ... urlPatterns) {
        this.servletMappings.put(servletName, Arrays.asList(urlPatterns));
        return this;
    }
}

