/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.pages.jasper;

import cloud.piranha.api.JspManager;
import cloud.piranha.api.WebApplication;
import cloud.piranha.pages.jasper.JasperJspManager;
import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.runtime.JspFactoryImpl;

public class JasperInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(JasperInitializer.class.getName());

    private String getClassesDirectory(ServletContext servletContext) {
        String result = servletContext.getRealPath("/WEB-INF/classes");
        result = result == null ? "" : File.pathSeparator + result;
        return result;
    }

    private String getJarFiles(ServletContext servletContext) {
        String[] files;
        File directory;
        StringBuilder result = new StringBuilder();
        String realPath = servletContext.getRealPath("/WEB-INF/lib");
        if (realPath != null && (directory = new File(realPath)).isDirectory() && (files = directory.list()) != null) {
            for (String file : files) {
                if (!file.toLowerCase().endsWith(".jar")) continue;
                result.append(File.pathSeparator);
                result.append(file);
            }
        }
        return result.toString();
    }

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        LOGGER.info("Initializing Jasper integration");
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
        }
        ServletRegistration.Dynamic registration = servletContext.addServlet("JSP Servlet", "org.apache.jasper.servlet.JspServlet");
        registration.addMapping(new String[]{"*.jsp"});
        String classpath = System.getProperty("java.class.path") + this.getClassesDirectory(servletContext) + this.getJarFiles(servletContext);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Jasper classpath is: {0}", classpath);
        }
        registration.setInitParameter("classpath", classpath);
        registration.setInitParameter("compilerSourceVM", "1.8");
        registration.setInitParameter("compilerTargetVM", "1.8");
        WebApplication webApplication = (WebApplication)servletContext;
        webApplication.setJspManager((JspManager)new JasperJspManager());
        LOGGER.info("Initializing Jasper integration");
    }
}

