/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.singlethread;

import cloud.piranha.DefaultHttpServerProcessor;
import cloud.piranha.DefaultHttpServerRequest;
import cloud.piranha.DefaultHttpServerResponse;
import cloud.piranha.api.HttpServer;
import cloud.piranha.api.HttpServerProcessor;
import cloud.piranha.api.HttpServerRequest;
import cloud.piranha.api.HttpServerResponse;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SingleThreadHttpServer
implements HttpServer,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(HttpServer.class.getName());
    protected HttpServerProcessor processor;
    protected boolean running;
    protected Thread serverProcessingThread;
    protected int serverPort;
    protected ServerSocket serverSocket;
    protected boolean serverStopRequest;
    protected int soTimeout;

    public SingleThreadHttpServer() {
        this.processor = new DefaultHttpServerProcessor();
        this.serverPort = 8080;
        this.serverStopRequest = false;
    }

    public SingleThreadHttpServer(int serverPort, HttpServerProcessor processor) {
        this.processor = processor;
        this.serverPort = serverPort;
        this.serverStopRequest = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        while (!this.serverStopRequest) {
            try {
                Socket socket = this.serverSocket.accept();
                Throwable throwable = null;
                try {
                    DefaultHttpServerRequest request = new DefaultHttpServerRequest(socket);
                    DefaultHttpServerResponse response = new DefaultHttpServerResponse(socket);
                    this.processor.process((HttpServerRequest)request, (HttpServerResponse)response);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (socket == null) continue;
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {}
        }
    }

    public void start() {
        try {
            this.serverStopRequest = false;
            this.serverSocket = new ServerSocket(this.serverPort);
            this.serverSocket.setReuseAddress(false);
            this.serverSocket.setSoTimeout(this.soTimeout);
            this.serverProcessingThread = new Thread((Runnable)this, "SingleThreadHttpServer");
            this.serverProcessingThread.start();
            this.running = true;
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "An I/O error occurred while starting the HTTP server", exception);
        }
    }

    public void stop() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException exception) {
                LOGGER.log(Level.WARNING, "An I/O error occurred while stopping the HTTP server", exception);
            }
            this.running = false;
        }
    }
}

