/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.netty;

import cloud.piranha.DefaultHttpServerProcessor;
import cloud.piranha.api.HttpServer;
import cloud.piranha.api.HttpServerProcessor;
import cloud.piranha.http.netty.NettyHttpServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;

public class NettyHttpServer
implements HttpServer {
    private EventLoopGroup bossGroup;
    private final HttpServerProcessor httpServerProcessor;
    private final int serverPort;
    private EventLoopGroup workerGroup;

    public NettyHttpServer() {
        this.httpServerProcessor = new DefaultHttpServerProcessor();
        this.serverPort = 8080;
    }

    public NettyHttpServer(int serverPort) {
        this.httpServerProcessor = new DefaultHttpServerProcessor();
        this.serverPort = serverPort;
    }

    public NettyHttpServer(int serverPort, HttpServerProcessor httpServerProcessor) {
        this.httpServerProcessor = httpServerProcessor;
        this.serverPort = serverPort;
    }

    public boolean isRunning() {
        return this.bossGroup != null && this.workerGroup != null;
    }

    public void start() {
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new NettyHttpServerInitializer(this.httpServerProcessor)).bind(this.serverPort);
    }

    public void stop() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.bossGroup = null;
        this.workerGroup = null;
    }
}

