/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.netty;

import cloud.piranha.api.HttpServerRequest;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NettyHttpServerRequest
implements HttpServerRequest {
    private final ChannelHandlerContext context;
    private InputStream inputStream;
    private Map<String, List<String>> queryParameters;
    private final FullHttpRequest request;

    public NettyHttpServerRequest(ChannelHandlerContext context, FullHttpRequest request) {
        this.context = context;
        this.request = request;
    }

    public String getHeader(String name) {
        return this.request.headers().get(name);
    }

    public Iterator<String> getHeaderNames() {
        return this.request.headers().names().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() {
        FullHttpRequest fullHttpRequest = this.request;
        synchronized (fullHttpRequest) {
            if (this.inputStream == null) {
                this.inputStream = new ByteBufInputStream(this.request.content());
            }
        }
        return this.inputStream;
    }

    public String getLocalAddress() {
        InetSocketAddress localAddress = (InetSocketAddress)this.context.channel().localAddress();
        return localAddress.getAddress().getHostAddress();
    }

    public String getLocalHostname() {
        InetSocketAddress localAddress = (InetSocketAddress)this.context.channel().localAddress();
        return localAddress.getAddress().getHostName();
    }

    public int getLocalPort() {
        InetSocketAddress localAddress = (InetSocketAddress)this.context.channel().localAddress();
        return localAddress.getPort();
    }

    public String getMethod() {
        return this.request.method().name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueryParameter(String name) {
        FullHttpRequest fullHttpRequest = this.request;
        synchronized (fullHttpRequest) {
            if (this.queryParameters == null) {
                QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.request.uri());
                this.queryParameters = queryStringDecoder.parameters();
            }
        }
        return this.queryParameters.get(name).get(0);
    }

    public String getQueryString() {
        String result = null;
        if (this.request.uri().contains("?")) {
            result = this.request.uri().substring(this.request.uri().indexOf("?") + 1);
        }
        return result;
    }

    public String getRemoteAddress() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.context.channel().remoteAddress();
        return remoteAddress.getAddress().getHostAddress();
    }

    public String getRemoteHostname() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.context.channel().remoteAddress();
        return remoteAddress.getAddress().getHostName();
    }

    public int getRemotePort() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.context.channel().remoteAddress();
        return remoteAddress.getPort();
    }

    public String getRequestTarget() {
        return this.request.uri();
    }
}

