/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.netty;

import cloud.piranha.api.HttpServerProcessor;
import cloud.piranha.http.netty.NettyHttpServerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;

@ChannelHandler.Sharable
public class NettyHttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private HttpServerProcessor httpServerProcessor;

    public NettyHttpServerInitializer(HttpServerProcessor httpServerProcessor) {
        this.httpServerProcessor = httpServerProcessor;
    }

    public void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(0xA00000)});
        pipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        pipeline.addLast(new ChannelHandler[]{new NettyHttpServerHandler(this.httpServerProcessor)});
    }
}

