/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.netty;

import cloud.piranha.api.HttpServerProcessor;
import cloud.piranha.api.HttpServerRequest;
import cloud.piranha.api.HttpServerResponse;
import cloud.piranha.http.netty.NettyHttpServerRequest;
import cloud.piranha.http.netty.NettyHttpServerResponse;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NettyHttpServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOGGER = Logger.getLogger(NettyHttpServerHandler.class.getName());
    private final HttpServerProcessor httpServerProcessor;

    public NettyHttpServerHandler(HttpServerProcessor httpServerProcessor) {
        this.httpServerProcessor = httpServerProcessor;
    }

    public void channelReadComplete(ChannelHandlerContext context) {
        context.flush();
    }

    protected void channelRead0(ChannelHandlerContext context, Object object) {
        if (object instanceof FullHttpRequest) {
            FullHttpRequest httpRequest = (FullHttpRequest)object;
            NettyHttpServerRequest nettyRequest = new NettyHttpServerRequest(context, httpRequest);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            NettyHttpServerResponse nettyResponse = new NettyHttpServerResponse((FullHttpResponse)response);
            this.httpServerProcessor.process((HttpServerRequest)nettyRequest, (HttpServerResponse)nettyResponse);
            context.write((Object)response);
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable throwable) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "Exception caught in NettyHttpServerHandler", throwable);
        }
        context.close();
    }
}

