/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.grizzly;

import cloud.piranha.DefaultHttpServerProcessor;
import cloud.piranha.api.HttpServer;
import cloud.piranha.api.HttpServerProcessor;
import cloud.piranha.api.HttpServerRequest;
import cloud.piranha.api.HttpServerResponse;
import cloud.piranha.http.grizzly.GrizzlyHttpServerRequest;
import cloud.piranha.http.grizzly.GrizzlyHttpServerResponse;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;

public class GrizzlyHttpServer
implements HttpServer {
    private static final Logger LOGGER = Logger.getLogger(GrizzlyHttpServer.class.getName());
    private final org.glassfish.grizzly.http.server.HttpServer httpServer;
    private HttpServerProcessor httpServerProcessor;

    public GrizzlyHttpServer() {
        this.httpServer = org.glassfish.grizzly.http.server.HttpServer.createSimpleServer();
        this.httpServerProcessor = new DefaultHttpServerProcessor();
        this.addHttpHandler();
    }

    public GrizzlyHttpServer(int serverPort) {
        this.httpServer = org.glassfish.grizzly.http.server.HttpServer.createSimpleServer(null, (int)serverPort);
        this.httpServerProcessor = new DefaultHttpServerProcessor();
        this.addHttpHandler();
    }

    public GrizzlyHttpServer(int serverPort, HttpServerProcessor httpServerProcessor) {
        this.httpServer = org.glassfish.grizzly.http.server.HttpServer.createSimpleServer(null, (int)serverPort);
        this.httpServerProcessor = httpServerProcessor;
        this.addHttpHandler();
    }

    public GrizzlyHttpServer(org.glassfish.grizzly.http.server.HttpServer httpServer) {
        this.httpServer = httpServer;
        this.httpServerProcessor = new DefaultHttpServerProcessor();
        this.addHttpHandler();
    }

    private void addHttpHandler() {
        this.httpServer.getServerConfiguration().addHttpHandler(new HttpHandler(){

            public void service(Request request, Response response) throws Exception {
                GrizzlyHttpServerRequest gRequest = new GrizzlyHttpServerRequest(request);
                GrizzlyHttpServerResponse gResponse = new GrizzlyHttpServerResponse(response);
                GrizzlyHttpServer.this.httpServerProcessor.process((HttpServerRequest)gRequest, (HttpServerResponse)gResponse);
            }
        });
    }

    public boolean isRunning() {
        return this.httpServer.isStarted();
    }

    public void start() {
        try {
            this.httpServer.start();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "An I/O error occurred while starting the HTTP server", ioe);
        }
    }

    public void stop() {
        this.httpServer.shutdownNow();
    }
}

