/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.api;

import cloud.piranha.http.api.HttpServer;
import cloud.piranha.http.api.HttpServerProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class HttpServerTest {
    protected abstract HttpServer createServer(int var1);

    protected abstract HttpServer createServer(int var1, HttpServerProcessor var2);

    @Test
    public void testAddHeader() {
        HttpServer server = this.createServer(8765, (request, response) -> {
            try {
                response.setStatus(200);
                response.setHeader("Content-Type", "text/plain");
                response.setHeader("Keep-Alive", "close");
                response.writeStatusLine();
                response.writeHeaders();
                OutputStream outputStream = response.getOutputStream();
                Iterator headerNames = request.getHeaderNames();
                while (headerNames.hasNext()) {
                    String name = (String)headerNames.next();
                    outputStream.write(name.getBytes());
                    outputStream.write("\n".getBytes());
                    outputStream.write(request.getHeader(name).getBytes());
                    outputStream.write("\n".getBytes());
                }
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        });
        server.start();
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request2 = HttpRequest.newBuilder(URI.create("http://localhost:8765")).header("name", "value1").build();
            HttpResponse<String> response2 = client.send(request2, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            Assertions.assertEquals((int)200, (int)response2.statusCode());
            String body = response2.body();
            Assertions.assertTrue((boolean)body.contains("name"));
            Assertions.assertTrue((boolean)body.contains("value1"));
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testFile() throws Exception {
        HttpServer server = this.createServer(8765);
        server.start();
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(URI.create("http://localhost:8765/pom.xml")).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            Assertions.assertEquals((int)200, (int)response.statusCode());
            String responseText = response.body();
            Assertions.assertTrue((boolean)responseText.contains("modelVersion"));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testFileNotFound() throws Exception {
        HttpServer server = this.createServer(8765);
        server.start();
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(URI.create("http://localhost:8765/this_is_certainly_not_there")).build();
            HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
            Assertions.assertEquals((int)404, (int)response.statusCode());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testGetLocalAddress() {
        HttpServer server = this.createServer(8765, (request, response) -> {
            try {
                response.setStatus(200);
                response.setHeader("Content-Type", "text/plain");
                response.setHeader("Keep-Alive", "close");
                response.writeStatusLine();
                response.writeHeaders();
                String value = request.getLocalAddress();
                OutputStream outputStream = response.getOutputStream();
                outputStream.write(value.getBytes());
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        });
        server.start();
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request2 = HttpRequest.newBuilder(URI.create("http://localhost:8765")).build();
            HttpResponse<String> response2 = client.send(request2, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            Assertions.assertEquals((int)200, (int)response2.statusCode());
            String body = response2.body();
            Assertions.assertTrue((boolean)body.contains("127.0.0.1"));
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testGetQueryParameter() {
        HttpServer server = this.createServer(8765, (request, response) -> {
            try {
                response.setStatus(200);
                response.setHeader("Content-Type", "text/plain");
                response.setHeader("Keep-Alive", "close");
                response.writeStatusLine();
                response.writeHeaders();
                String value = request.getQueryParameter("name");
                OutputStream outputStream = response.getOutputStream();
                outputStream.write(value.getBytes());
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        });
        server.start();
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request2 = HttpRequest.newBuilder(URI.create("http://localhost:8765/?name=value")).build();
            HttpResponse<String> response2 = client.send(request2, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            Assertions.assertEquals((int)200, (int)response2.statusCode());
            String body = response2.body();
            Assertions.assertTrue((boolean)body.contains("value"));
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testGetQueryParameter2() {
        HttpServer server = this.createServer(8765, (request, response) -> {
            try {
                response.setStatus(200);
                response.setHeader("Content-Type", "text/plain");
                response.setHeader("Keep-Alive", "close");
                response.writeStatusLine();
                response.writeHeaders();
                String value = request.getQueryParameter("name");
                OutputStream outputStream = response.getOutputStream();
                outputStream.write(value.getBytes());
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        });
        server.start();
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request2 = HttpRequest.newBuilder(URI.create("http://localhost:8765/?name=value&name=value2")).build();
            HttpResponse<String> response2 = client.send(request2, HttpResponse.BodyHandlers.ofString());
            Assertions.assertEquals((int)200, (int)response2.statusCode());
            String body = response2.body();
            Assertions.assertTrue((boolean)body.contains("value"));
            Assertions.assertFalse((boolean)body.contains("value2"));
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testGetQueryString() {
        HttpServer server = this.createServer(8765, (request, response) -> {
            try {
                response.setStatus(200);
                response.setHeader("Content-Type", "text/plain");
                response.setHeader("Keep-Alive", "close");
                response.writeStatusLine();
                response.writeHeaders();
                String queryString = request.getQueryString();
                OutputStream outputStream = response.getOutputStream();
                outputStream.write(queryString.getBytes());
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        });
        server.start();
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request2 = HttpRequest.newBuilder(URI.create("http://localhost:8765/?name=value")).build();
            HttpResponse<String> response2 = client.send(request2, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            Assertions.assertEquals((int)200, (int)response2.statusCode());
            String body = response2.body();
            Assertions.assertTrue((boolean)body.contains("name=value"));
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testProcessing() throws Exception {
        HttpServer server = this.createServer(8765);
        server.start();
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(URI.create("http://localhost:8765")).build();
            HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
            Assertions.assertEquals((int)200, (int)response.statusCode());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testProcessing2() throws Exception {
        HttpServer server = this.createServer(8765);
        server.start();
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(URI.create("http://localhost:8765")).build();
            HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
            Assertions.assertEquals((int)200, (int)response.statusCode());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testStartAndStop() throws Exception {
        HttpServer server = this.createServer(8765);
        server.start();
        Assertions.assertTrue((boolean)server.isRunning());
        server.stop();
        Assertions.assertFalse((boolean)server.isRunning());
    }
}

