/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.arquillian.server;

import cloud.piranha.arquillian.server.PiranhaServerContainerConfiguration;
import cloud.piranha.arquillian.server.StaticURLStreamHandlerFactory;
import cloud.piranha.resource.DefaultResourceManager;
import cloud.piranha.resource.api.Resource;
import cloud.piranha.resource.api.ResourceManager;
import cloud.piranha.resource.shrinkwrap.IsolatingResourceManagerClassLoader;
import cloud.piranha.resource.shrinkwrap.ShrinkWrapResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepositories;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenUpdatePolicy;

public class PiranhaServerDeployableContainer
implements DeployableContainer<PiranhaServerContainerConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(PiranhaServerDeployableContainer.class.getName());
    private PiranhaServerContainerConfiguration configuration;
    private Object piranhaServerDeployer;

    public Class<PiranhaServerContainerConfiguration> getConfigurationClass() {
        return PiranhaServerContainerConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public void setup(PiranhaServerContainerConfiguration configuration) {
        this.configuration = configuration;
        configuration.validate();
    }

    public void start() throws LifecycleException {
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        HashSet servletNames = new HashSet();
        if (!archive.contains("WEB-INF/beans.xml")) {
            archive.add((Asset)EmptyAsset.INSTANCE, "WEB-INF/beans.xml");
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ConfigurableMavenResolverSystem mavenResolver = Maven.configureResolver();
            this.configuration.getRepositoriesList().stream().forEach(repoUrl -> {
                ConfigurableMavenResolverSystem cfr_ignored_0 = (ConfigurableMavenResolverSystem)mavenResolver.withRemoteRepo(this.createRepo((String)repoUrl));
            });
            JavaArchive[] piranhaArchives = (JavaArchive[])((MavenFormatStage)((MavenStrategyStage)((ConfigurableMavenResolverSystem)mavenResolver.workOffline(this.configuration.isOffline())).resolve(this.configuration.getMergedDependencies())).withTransitivity()).as(JavaArchive.class);
            ClassLoader piranhaClassLoader = this.getPiranhaClassLoader((Archive<?>[])piranhaArchives);
            ClassLoader webInfClassLoader = this.getWebInfClassLoader(archive, piranhaClassLoader);
            Thread.currentThread().setContextClassLoader(webInfClassLoader);
            try {
                URL.setURLStreamHandlerFactory(new StaticURLStreamHandlerFactory());
            }
            catch (Error error) {
                // empty catch block
            }
            this.piranhaServerDeployer = Class.forName("cloud.piranha.micro.PiranhaServerDeployer", true, webInfClassLoader).newInstance();
            servletNames.addAll((Set)this.piranhaServerDeployer.getClass().getMethod("start", Archive.class, ClassLoader.class, Map.class).invoke(this.piranhaServerDeployer, archive, webInfClassLoader, StaticURLStreamHandlerFactory.getHandlers()));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new DeploymentException("", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        HTTPContext httpContext = new HTTPContext("localhost", 9090);
        for (String servletName : servletNames) {
            httpContext.add(new Servlet(servletName, "/"));
        }
        ProtocolMetaData protocolMetaData = new ProtocolMetaData();
        protocolMetaData.addContext((Object)httpContext);
        return protocolMetaData;
    }

    ClassLoader getPiranhaClassLoader(Archive<?>[] piranhaArchives) {
        DefaultResourceManager manager = new DefaultResourceManager();
        for (Archive<?> archive : piranhaArchives) {
            manager.addResource((Resource)new ShrinkWrapResource(archive));
        }
        IsolatingResourceManagerClassLoader classLoader = new IsolatingResourceManagerClassLoader("Piranha Loader");
        classLoader.setResourceManager((ResourceManager)manager);
        return classLoader;
    }

    ClassLoader getWebInfClassLoader(Archive<?> applicationArchive, ClassLoader piranhaClassloader) {
        ShrinkWrapResource applicationResource = new ShrinkWrapResource("/WEB-INF/classes", applicationArchive);
        ShrinkWrapResource indexResource = new ShrinkWrapResource(((JavaArchive)ShrinkWrap.create(JavaArchive.class)).add((Asset)new ByteArrayAsset(this.createIndex(applicationResource)), "META-INF/piranha.idx"));
        IsolatingResourceManagerClassLoader classLoader = new IsolatingResourceManagerClassLoader(piranhaClassloader, "WebInf Loader");
        DefaultResourceManager manager = new DefaultResourceManager();
        manager.addResource((Resource)applicationResource);
        manager.addResource((Resource)indexResource);
        classLoader.setResourceManager((ResourceManager)manager);
        return classLoader;
    }

    private byte[] createIndex(ShrinkWrapResource applicationResource) {
        ByteArrayOutputStream indexBytes;
        block2: {
            Indexer indexer = new Indexer();
            applicationResource.getAllLocations().filter(e -> e.endsWith(".class")).forEach(className -> this.addToIndex((String)className, applicationResource, indexer));
            Index index = indexer.complete();
            indexBytes = new ByteArrayOutputStream();
            IndexWriter writer = new IndexWriter((OutputStream)indexBytes);
            try {
                writer.write(index);
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block2;
                LOGGER.log(Level.WARNING, "Unable to write out index", ioe);
            }
        }
        return indexBytes.toByteArray();
    }

    private void addToIndex(String className, ShrinkWrapResource resource, Indexer indexer) {
        block14: {
            try (InputStream classAsStream = resource.getResourceAsStream(className);){
                indexer.index(classAsStream);
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block14;
                LOGGER.log(Level.WARNING, "Unable to add to index", ioe);
            }
        }
    }

    private MavenRemoteRepository createRepo(String repoUrl) {
        MavenRemoteRepository repo = MavenRemoteRepositories.createRemoteRepository((String)UUID.randomUUID().toString(), (String)repoUrl, (String)"default");
        repo.setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_NEVER);
        return repo;
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        block2: {
            try {
                this.piranhaServerDeployer.getClass().getMethod("stop", new Class[0]).invoke(this.piranhaServerDeployer, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block2;
                LOGGER.log(Level.WARNING, "Error occurred during undeploy", e);
            }
        }
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
    }

    public void stop() throws LifecycleException {
    }
}

