/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.arquillian.server;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class PiranhaServerContainerConfiguration
implements ContainerConfiguration {
    private String version;
    private String modules;
    private String dependencies;
    private String repositories;
    private boolean offline;
    private List<String> modulesList;
    private List<String> repositoriesList;
    private List<String> mergedDependencies;

    public PiranhaServerContainerConfiguration() {
        this(System.getProperty("piranha.version", "20.2.0"), System.getProperty("piranha.modules", "piranha-micro"), System.getProperty("piranha.dependencies", ""), System.getProperty("piranha.repositories", "https://repo1.maven.org/maven2"), Boolean.valueOf(System.getProperty("piranha.offline", "false")), null, null, null);
    }

    public PiranhaServerContainerConfiguration(String version, String modules, String dependencies, String repositories, boolean offline, List<String> modulesList, List<String> repositoriesList, List<String> mergedDependencies) {
        this.version = version;
        this.modules = modules;
        this.dependencies = dependencies;
        this.repositories = repositories;
        this.offline = offline;
        this.modulesList = modulesList;
        this.repositoriesList = repositoriesList;
        this.mergedDependencies = mergedDependencies;
    }

    public void validate() throws ConfigurationException {
        this.modulesList = Arrays.stream(this.modules.split(",")).map(module -> module.trim()).collect(Collectors.toList());
        Stream<String> moduleDependenciesStream = this.modulesList.stream().map(module -> "cloud.piranha:" + module + ":" + this.version);
        Stream<String> dependenciesStream = Arrays.stream(this.dependencies.split(",")).map(dep -> dep.trim()).filter(dep -> !dep.isEmpty());
        this.repositoriesList = Arrays.stream(this.repositories.split(",")).map(repo -> repo.trim()).filter(repo -> !repo.isEmpty()).collect(Collectors.toList());
        this.mergedDependencies = Stream.concat(moduleDependenciesStream, dependenciesStream).collect(Collectors.toList());
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getModules() {
        return this.modules;
    }

    public void setModules(String modules) {
        this.modules = modules;
    }

    public String getRepositories() {
        return this.repositories;
    }

    public void setRepositories(String repositories) {
        this.repositories = repositories;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public List<String> getModulesList() {
        return this.modulesList;
    }

    public List<String> getRepositoriesList() {
        return this.repositoriesList;
    }

    public List<String> getMergedDependencies() {
        return this.mergedDependencies;
    }
}

