/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.arquillian.server;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class PiranhaServerContainerConfiguration
implements ContainerConfiguration {
    private String version = System.getProperty("piranha.version", "20.1.0-SNAPSHOT");
    private String modules = System.getProperty("piranha.modules", "piranha-micro");
    private String dependencies = System.getProperty("piranha.dependencies", "");
    private String repositories = System.getProperty("piranha.repositories", "");
    private boolean offline = Boolean.valueOf(System.getProperty("piranha.offline", "false"));
    private List<String> modulesList;
    private List<String> repositoriesList;
    private List<String> mergedDependencies;

    public void validate() throws ConfigurationException {
        this.modulesList = Arrays.stream(this.modules.split(",")).map(e -> e.trim()).collect(Collectors.toList());
        Stream<String> moduleDependenciesStream = this.modulesList.stream().map(e -> "cloud.piranha:" + e + ":" + this.version);
        Stream<String> dependenciesStream = Arrays.stream(this.dependencies.split(",")).map(e -> e.trim()).filter(e -> !e.isEmpty());
        this.repositoriesList = Arrays.stream(this.repositories.split(",")).map(e -> e.trim()).filter(e -> !e.isEmpty()).collect(Collectors.toList());
        this.mergedDependencies = Stream.concat(moduleDependenciesStream, dependenciesStream).collect(Collectors.toList());
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getModules() {
        return this.modules;
    }

    public void setModules(String modules) {
        this.modules = modules;
    }

    public String getRepositories() {
        return this.repositories;
    }

    public void setRepositories(String repositories) {
        this.repositories = repositories;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public List<String> getModulesList() {
        return this.modulesList;
    }

    public List<String> getRepositoriesList() {
        return this.repositoriesList;
    }

    public List<String> getMergedDependencies() {
        return this.mergedDependencies;
    }
}

