/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.appserver.impl;

import cloud.piranha.appserver.api.WebApplicationServerRequestMapper;
import cloud.piranha.webapp.api.WebApplication;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultWebApplicationServerRequestMapper
implements WebApplicationServerRequestMapper {
    private final ConcurrentHashMap<String, WebApplication> mappings = new ConcurrentHashMap();

    public Set<String> addMapping(WebApplication webApplication, String ... urlPatterns) {
        HashSet<String> result = new HashSet<String>();
        for (String urlPattern : urlPatterns) {
            if (this.mappings.containsKey(urlPattern)) {
                result.add(urlPattern);
                continue;
            }
            this.mappings.put(urlPattern, webApplication);
        }
        return result;
    }

    public WebApplication findMapping(String path) {
        WebApplication result = null;
        String mapping = this.findPrefixMatch(path);
        if (mapping != null) {
            result = this.mappings.get(mapping);
        }
        return result;
    }

    private String findPrefixMatch(String path) {
        String found;
        String result = null;
        while ((found = this.findPrefixMatch(path, result)) != null) {
            result = found;
        }
        return result;
    }

    public String findPrefixMatch(String path, String currentPrefix) {
        String result = null;
        Enumeration<String> prefixes = this.mappings.keys();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            if (!path.startsWith(prefix)) continue;
            if (result != null) break;
            result = prefix;
            break;
        }
        if (result != null && currentPrefix != null && result.length() <= currentPrefix.length()) {
            result = null;
        }
        return result;
    }
}

