/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.appserver.impl;

import cloud.piranha.appserver.api.WebApplicationServerRequest;
import cloud.piranha.webapp.impl.DefaultWebApplicationRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;

public class DefaultWebApplicationServerRequest
extends DefaultWebApplicationRequest
implements WebApplicationServerRequest {
    public static DefaultWebApplicationServerRequest fromMap(Map<String, Object> requestMap) {
        DefaultWebApplicationServerRequest applicationRequest = new DefaultWebApplicationServerRequest();
        applicationRequest.setLocalAddr((String)requestMap.get("Address"));
        applicationRequest.setLocalName((String)requestMap.get("LocalName"));
        applicationRequest.setLocalPort((Integer)requestMap.get("LocalPort"));
        applicationRequest.setRemoteAddr((String)requestMap.get("RemoteAddr"));
        applicationRequest.setRemoteHost((String)requestMap.get("RemoteHost"));
        applicationRequest.setRemotePort((Integer)requestMap.get("RemotePort"));
        applicationRequest.setServerName((String)requestMap.get("ServerName"));
        applicationRequest.setServerPort((Integer)requestMap.get("ServerPort"));
        applicationRequest.setMethod((String)requestMap.get("Method"));
        applicationRequest.setContextPath((String)requestMap.get("ContextPath"));
        applicationRequest.setServletPath((String)requestMap.get("ServletPath"));
        applicationRequest.setQueryString((String)requestMap.get("QueryString"));
        applicationRequest.setInputStream((InputStream)requestMap.get("InputStream"));
        for (Map.Entry headerEntry : ((Map)requestMap.get("Headers")).entrySet()) {
            String name = (String)headerEntry.getKey();
            List values = (List)headerEntry.getValue();
            for (String value : values) {
                applicationRequest.setHeader(name, value);
                if (name.equalsIgnoreCase("Content-Type")) {
                    applicationRequest.setContentType(value);
                }
                if (name.equalsIgnoreCase("Content-Length")) {
                    applicationRequest.setContentLength(Integer.parseInt(value));
                }
                if (!name.equalsIgnoreCase("COOKIE")) continue;
                applicationRequest.setCookies(DefaultWebApplicationServerRequest.processCookies(applicationRequest, value));
            }
        }
        return applicationRequest;
    }

    private static Cookie[] processCookies(DefaultWebApplicationServerRequest result, String cookiesValue) {
        String[] cookieCandidates;
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        for (String cookieCandidate : cookieCandidates = cookiesValue.split(";")) {
            Cookie cookie;
            String[] cookieString = cookieCandidate.split("=");
            String cookieName = cookieString[0].trim();
            String cookieValue = null;
            if (cookieString.length == 2) {
                cookieValue = cookieString[1].trim();
            }
            if ((cookie = new Cookie(cookieName, cookieValue)).getName().equals("JSESSIONID")) {
                result.setRequestedSessionIdFromCookie(true);
                result.setRequestedSessionId(cookie.getValue());
                continue;
            }
            cookieList.add(cookie);
        }
        return cookieList.toArray(new Cookie[0]);
    }
}

