/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.appserver.impl;

import cloud.piranha.appserver.api.WebApplicationServer;
import cloud.piranha.appserver.api.WebApplicationServerRequest;
import cloud.piranha.appserver.api.WebApplicationServerRequestMapper;
import cloud.piranha.appserver.api.WebApplicationServerResponse;
import cloud.piranha.appserver.impl.DefaultWebApplicationServerRequest;
import cloud.piranha.appserver.impl.DefaultWebApplicationServerRequestMapper;
import cloud.piranha.appserver.impl.DefaultWebApplicationServerResponse;
import cloud.piranha.http.api.HttpServerProcessor;
import cloud.piranha.http.api.HttpServerRequest;
import cloud.piranha.http.api.HttpServerResponse;
import cloud.piranha.webapp.api.WebApplication;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;

public class DefaultWebApplicationServer
implements HttpServerProcessor,
WebApplicationServer {
    private static final Logger LOGGER = Logger.getLogger(DefaultWebApplicationServer.class.getName());
    protected WebApplicationServerRequestMapper requestMapper = new DefaultWebApplicationServerRequestMapper();
    protected final Map<String, WebApplication> webApplications = new ConcurrentHashMap<String, WebApplication>();

    public void addMapping(String servletContextName, String contextPath) {
        for (WebApplication webApp : this.webApplications.values()) {
            if (!webApp.getServletContextName().equals(servletContextName)) continue;
            this.requestMapper.addMapping(webApp, new String[]{contextPath});
            break;
        }
    }

    public void addWebApplication(WebApplication webApplication) {
        LOGGER.log(Level.FINE, () -> "Adding web application with context path: " + webApplication.getContextPath());
        this.webApplications.put(webApplication.getContextPath(), webApplication);
        this.requestMapper.addMapping(webApplication, new String[]{webApplication.getContextPath()});
    }

    private WebApplicationServerRequest createRequest(HttpServerRequest request) {
        DefaultWebApplicationServerRequest applicationServerRequest = new DefaultWebApplicationServerRequest();
        this.copyHttpRequestToApplicationRequest(request, applicationServerRequest);
        applicationServerRequest.setServletPath("");
        Iterator headerNames = request.getHeaderNames();
        while (headerNames.hasNext()) {
            String name = (String)headerNames.next();
            String value = request.getHeader(name);
            applicationServerRequest.setHeader(name, value);
            if (name.equalsIgnoreCase("Content-Type")) {
                applicationServerRequest.setContentType(value);
            }
            if (name.equalsIgnoreCase("Content-Length")) {
                applicationServerRequest.setContentLength(Integer.parseInt(value));
            }
            if (!name.equalsIgnoreCase("COOKIE")) continue;
            applicationServerRequest.setCookies(this.processCookies(applicationServerRequest, value));
        }
        return applicationServerRequest;
    }

    private Cookie[] processCookies(DefaultWebApplicationServerRequest result, String cookiesValue) {
        String[] cookieCandidates;
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        for (String cookieCandidate : cookieCandidates = cookiesValue.split(";")) {
            Cookie cookie;
            String[] cookieString = cookieCandidate.split("=");
            String cookieName = cookieString[0].trim();
            String cookieValue = null;
            if (cookieString.length == 2) {
                cookieValue = cookieString[1].trim();
            }
            if ((cookie = new Cookie(cookieName, cookieValue)).getName().equals("JSESSIONID")) {
                result.setRequestedSessionIdFromCookie(true);
                result.setRequestedSessionId(cookie.getValue());
                continue;
            }
            cookieList.add(cookie);
        }
        return cookieList.toArray(new Cookie[0]);
    }

    private void copyHttpRequestToApplicationRequest(HttpServerRequest httpRequest, DefaultWebApplicationServerRequest applicationRequest) {
        applicationRequest.setLocalAddr(httpRequest.getLocalAddress());
        applicationRequest.setLocalName(httpRequest.getLocalHostname());
        applicationRequest.setLocalPort(httpRequest.getLocalPort());
        applicationRequest.setRemoteAddr(httpRequest.getRemoteAddress());
        applicationRequest.setRemoteHost(httpRequest.getRemoteHostname());
        applicationRequest.setRemotePort(httpRequest.getRemotePort());
        applicationRequest.setServerName(httpRequest.getLocalHostname());
        applicationRequest.setServerPort(httpRequest.getLocalPort());
        applicationRequest.setMethod(httpRequest.getMethod());
        applicationRequest.setContextPath(httpRequest.getRequestTarget());
        applicationRequest.setQueryString(httpRequest.getQueryString());
        applicationRequest.setInputStream(httpRequest.getInputStream());
    }

    public WebApplicationServerResponse createResponse(HttpServerResponse httpResponse) {
        DefaultWebApplicationServerResponse applicationResponse = new DefaultWebApplicationServerResponse();
        applicationResponse.setUnderlyingOutputStream(httpResponse.getOutputStream());
        applicationResponse.setResponseCloser(() -> {
            try {
                httpResponse.closeResponse();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, ioe, () -> "IOException when flushing the underlying async output stream");
            }
        });
        return applicationResponse;
    }

    public WebApplicationServerRequestMapper getRequestMapper() {
        return this.requestMapper;
    }

    public void initialize() {
        LOGGER.log(Level.FINE, "Starting initialization of {0} web application(s)", this.webApplications.size());
        this.webApplications.values().forEach(webApp -> {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(webApp.getClassLoader());
                webApp.initialize();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        });
        LOGGER.log(Level.FINE, "Finished initialization of {0} web application(s)", this.webApplications.size());
    }

    public boolean process(HttpServerRequest request, HttpServerResponse response) {
        try {
            DefaultWebApplicationServerRequest serverRequest = (DefaultWebApplicationServerRequest)this.createRequest(request);
            DefaultWebApplicationServerResponse serverResponse = (DefaultWebApplicationServerResponse)this.createResponse(response);
            this.service(serverRequest, serverResponse);
            return serverRequest.isAsyncStarted();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(WebApplicationServerRequest request, WebApplicationServerResponse response) throws IOException, ServletException {
        String requestUri = request.getRequestURI();
        if (requestUri == null) {
            response.sendError(500);
            return;
        }
        WebApplication webApplication = this.requestMapper.findMapping(requestUri);
        if (webApplication == null) {
            response.sendError(404);
            return;
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(webApplication.getClassLoader());
            String contextPath = webApplication.getContextPath();
            request.setContextPath(contextPath);
            request.setServletPath(requestUri.substring(contextPath.length()));
            request.setWebApplication(webApplication);
            response.setWebApplication(webApplication);
            webApplication.service((ServletRequest)request, (ServletResponse)response);
            request.getParameterMap();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public void setRequestMapper(WebApplicationServerRequestMapper requestMapper) {
        this.requestMapper = requestMapper;
    }

    public void start() {
        LOGGER.fine("Starting WebApplication server engine");
        this.webApplications.values().forEach(webApp -> {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(webApp.getClassLoader());
                webApp.start();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        });
        LOGGER.fine("Started WebApplication server engine");
    }

    public void stop() {
        LOGGER.fine("Stopping WebApplication server engine");
        this.webApplications.values().forEach(webApp -> {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(webApp.getClassLoader());
                webApp.stop();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        });
        LOGGER.fine("Stopped WebApplication server engine");
    }
}

