/*
 * Decompiled with CFR 0.152.
 */
package orbit.util.time;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import orbit.util.time.TimestampKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0002J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u0011J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lorbit/util/time/Timestamp;", "", "seconds", "", "nanos", "", "(JI)V", "getNanos", "()I", "getSeconds", "()J", "compareTo", "timestamp", "component1", "component2", "copy", "equals", "", "other", "hashCode", "inFuture", "inPast", "toString", "", "Companion", "orbit-util"})
public final class Timestamp {
    private final long seconds;
    private final int nanos;
    public static final Companion Companion = new Companion(null);

    public final int compareTo(@NotNull Timestamp timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        long l = this.seconds - timestamp.seconds;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        boolean bl = false;
        boolean bl2 = false;
        long secondCompare = l2;
        boolean bl3 = false;
        return (int)(secondCompare != false ? secondCompare : (long)Intrinsics.compare((int)this.nanos, (int)timestamp.nanos));
    }

    public final boolean inPast() {
        return this.compareTo(Companion.now()) < 0;
    }

    public final boolean inFuture() {
        return !this.inPast();
    }

    public final long getSeconds() {
        return this.seconds;
    }

    public final int getNanos() {
        return this.nanos;
    }

    public Timestamp(long seconds, int nanos) {
        this.seconds = seconds;
        this.nanos = nanos;
    }

    public final long component1() {
        return this.seconds;
    }

    public final int component2() {
        return this.nanos;
    }

    @NotNull
    public final Timestamp copy(long seconds, int nanos) {
        return new Timestamp(seconds, nanos);
    }

    public static /* synthetic */ Timestamp copy$default(Timestamp timestamp, long l, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l = timestamp.seconds;
        }
        if ((n2 & 2) != 0) {
            n = timestamp.nanos;
        }
        return timestamp.copy(l, n);
    }

    @NotNull
    public String toString() {
        return "Timestamp(seconds=" + this.seconds + ", nanos=" + this.nanos + ")";
    }

    public int hashCode() {
        return Long.hashCode(this.seconds) * 31 + Integer.hashCode(this.nanos);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Timestamp)) break block3;
                Timestamp timestamp = (Timestamp)object;
                if (this.seconds != timestamp.seconds || this.nanos != timestamp.nanos) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lorbit/util/time/Timestamp$Companion;", "", "()V", "now", "Lorbit/util/time/Timestamp;", "orbit-util"})
    public static final class Companion {
        @NotNull
        public final Timestamp now() {
            Instant instant = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
            return TimestampKt.toTimestamp(instant);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

