/*
 * Decompiled with CFR 0.152.
 */
package orbit.util.time;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import orbit.util.time.ClockUtils;
import orbit.util.time.Timestamp;
import orbit.util.time.TimestampKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0004j\u0002`\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u0016\u001a\n \u0013*\u0004\u0018\u00010\u00170\u00172\u0006\u0010\u000e\u001a\u00020\u000fR\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorbit/util/time/Clock;", "", "()V", "currentTime", "", "Lorbit/util/time/TimeMs;", "getCurrentTime", "()J", "offsetTime", "advanceTime", "", "offset", "inFuture", "", "time", "Lorbit/util/time/Timestamp;", "inPast", "now", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "nowOrPast", "resetToNow", "until", "Ljava/time/Duration;", "orbit-util"})
public final class Clock {
    private long offsetTime;

    public final long getCurrentTime() {
        return ClockUtils.INSTANCE.currentTimeMillis() + this.offsetTime;
    }

    public final Instant now() {
        return Instant.ofEpochMilli(this.getCurrentTime());
    }

    public final void advanceTime(long offset) {
        this.offsetTime += offset;
    }

    public final void resetToNow() {
        this.offsetTime = 0L;
    }

    public final boolean inFuture(@NotNull Timestamp time2) {
        Intrinsics.checkParameterIsNotNull((Object)time2, (String)"time");
        Instant instant = this.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"now()");
        return time2.isAfter(instant);
    }

    public final boolean inPast(@NotNull Timestamp time2) {
        Intrinsics.checkParameterIsNotNull((Object)time2, (String)"time");
        return !this.inFuture(time2);
    }

    public final boolean nowOrPast(@NotNull Timestamp time2) {
        Intrinsics.checkParameterIsNotNull((Object)time2, (String)"time");
        Instant instant = this.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"now()");
        return time2.isExactly(instant) || this.inPast(time2);
    }

    public final Duration until(@NotNull Timestamp time2) {
        Intrinsics.checkParameterIsNotNull((Object)time2, (String)"time");
        return Duration.between(this.now(), TimestampKt.toInstant(time2));
    }
}

