/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.spring.actuate;

import cloud.orbit.actors.extensions.LifetimeExtension;
import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.concurrent.Task;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncLifetimeExtension
implements LifetimeExtension {
    private static final Logger log = LoggerFactory.getLogger(AsyncLifetimeExtension.class);
    private final Executor executor;

    public AsyncLifetimeExtension(Executor executor) {
        this.executor = executor;
    }

    public Task<?> postActivation(AbstractActor<?> actor) {
        this.executor.execute(new AsyncJob(actor, true));
        return Task.done();
    }

    public Task<?> postDeactivation(AbstractActor<?> actor) {
        this.executor.execute(new AsyncJob(actor, false));
        return Task.done();
    }

    protected abstract Task postActivationAsync(AbstractActor<?> var1);

    protected abstract Task postDeactivationAsync(AbstractActor<?> var1);

    private class AsyncJob
    implements Runnable {
        private final WeakReference<AbstractActor<?>> actorReference;
        private final boolean isActivation;

        private AsyncJob(AbstractActor<?> actor, boolean isActivation) {
            this.actorReference = new WeakReference(actor);
            this.isActivation = isActivation;
        }

        @Override
        public void run() {
            AbstractActor actor = (AbstractActor)this.actorReference.get();
            if (actor == null) {
                log.debug("Lost reference to actor. Skipping background lifecycle handling.");
            } else if (this.isActivation) {
                AsyncLifetimeExtension.this.postActivationAsync(actor).join();
            } else {
                AsyncLifetimeExtension.this.postDeactivationAsync(actor).join();
            }
        }
    }
}

