/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.spring.actuate;

import cloud.orbit.spring.actuate.ActorInfoContributorConfiguration;
import cloud.orbit.spring.actuate.ActorInfoContributorReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.boot.actuate.info.Info;

class ActorInfoDetailsContainer {
    private final List<Function<ActorInfoContributorReference, String>> detailLevelHandlers = new ArrayList<Function<ActorInfoContributorReference, String>>();
    private final Map<String, Object> details = new HashMap<String, Object>();

    ActorInfoDetailsContainer(ActorInfoContributorConfiguration.GroupProperties groupProperties) {
        Stream.of(groupProperties.getPrimary(), groupProperties.getSecondary()).map(this::deriveHandlerFromGroupType).forEach(handler -> handler.ifPresent(this.detailLevelHandlers::add));
    }

    private Optional<Function<ActorInfoContributorReference, String>> deriveHandlerFromGroupType(ActorInfoContributorConfiguration.GroupProperties.GroupType groupType) {
        if (groupType == ActorInfoContributorConfiguration.GroupProperties.GroupType.IDENTITY) {
            return Optional.of(ActorInfoContributorReference::getIdentity);
        }
        if (groupType == ActorInfoContributorConfiguration.GroupProperties.GroupType.INTERFACE) {
            return Optional.of(ActorInfoContributorReference::getName);
        }
        return Optional.empty();
    }

    synchronized void mergeDetailsFrom(ActorInfoContributorReference actorInfoContributorReference) {
        Info.Builder builder = new Info.Builder();
        actorInfoContributorReference.getInfoContributor().contribute(builder);
        Map whereToPutDetails = this.details;
        for (Function<ActorInfoContributorReference, String> handler : this.detailLevelHandlers) {
            String key = handler.apply(actorInfoContributorReference);
            whereToPutDetails.putIfAbsent((String)key, new HashMap());
            whereToPutDetails = (Map)whereToPutDetails.get(key);
        }
        whereToPutDetails.putAll(builder.build().getDetails());
    }

    synchronized Map<String, Object> getDetailsSnapshot() {
        HashMap<String, Object> detailsCopy = new HashMap<String, Object>(this.details);
        this.details.clear();
        return detailsCopy;
    }
}

