/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.spring.actuate;

import cloud.orbit.actors.Actor;
import cloud.orbit.actors.runtime.AbstractActor;
import java.lang.ref.WeakReference;
import java.util.function.Function;
import org.springframework.boot.actuate.info.InfoContributor;

class ActorInfoContributorReference {
    private final WeakReference<InfoContributor> reference;
    private final String name;
    private final String identity;

    ActorInfoContributorReference(Function<AbstractActor, Class> actorTypeResolver, AbstractActor<?> actor) {
        this.reference = new WeakReference<InfoContributor>((InfoContributor)actor);
        this.name = actorTypeResolver.apply(actor).getSimpleName();
        this.identity = ((Actor)actor).getIdentity();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActorInfoContributorReference that = (ActorInfoContributorReference)o;
        return this.name.equals(that.name) && this.identity.equals(that.identity);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.identity.hashCode();
    }

    InfoContributor getInfoContributor() {
        InfoContributor infoContributor = (InfoContributor)this.reference.get();
        if (infoContributor == null) {
            throw new ExpiredReferenceException(this);
        }
        return infoContributor;
    }

    String getName() {
        return this.name;
    }

    String getIdentity() {
        return this.identity;
    }

    static class ExpiredReferenceException
    extends RuntimeException {
        private ExpiredReferenceException(ActorInfoContributorReference reference) {
            super(reference.toString());
        }
    }
}

