/*
 Copyright (C) 2017 Electronic Arts Inc.  All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

 1.  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
 2.  Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
 3.  Neither the name of Electronic Arts, Inc. ("EA") nor the names of
     its contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY ELECTRONIC ARTS AND ITS CONTRIBUTORS "AS IS" AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL ELECTRONIC ARTS OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package cloud.orbit.spring.actuate;

import org.springframework.boot.actuate.info.InfoContributor;

import cloud.orbit.actors.Actor;
import cloud.orbit.actors.runtime.AbstractActor;

import java.lang.ref.WeakReference;
import java.util.function.Function;

class ActorInfoContributorReference
{
    private final WeakReference<InfoContributor> reference;
    private final String name;
    private final String identity;

    ActorInfoContributorReference(final Function<AbstractActor, Class> actorTypeResolver, final AbstractActor<?> actor)
    {
        reference = new WeakReference<>((InfoContributor) actor);
        name = actorTypeResolver.apply(actor).getSimpleName();
        identity = ((Actor) actor).getIdentity();
    }

    @Override
    public boolean equals(final Object o)
    {
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }
        final ActorInfoContributorReference that = (ActorInfoContributorReference) o;
        return name.equals(that.name) && identity.equals(that.identity);
    }

    @Override
    public int hashCode()
    {
        return name.hashCode() ^ identity.hashCode();
    }

    InfoContributor getInfoContributor()
    {
        InfoContributor infoContributor = reference.get();
        if (infoContributor == null)
        {
            throw new ExpiredReferenceException(this);
        }
        return infoContributor;
    }

    String getName()
    {
        return name;
    }

    String getIdentity()
    {
        return identity;
    }

    static class ExpiredReferenceException extends RuntimeException
    {
        private ExpiredReferenceException(final ActorInfoContributorReference reference)
        {
            super(reference.toString());
        }
    }
}
