/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.spring.actuate;

import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.spring.OrbitSpringConfiguration;
import cloud.orbit.spring.actuate.ActorInfoContributorLifetimeExtension;
import cloud.orbit.spring.actuate.ActorInfoDetailsContainer;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={InfoContributor.class})
@ConditionalOnEnabledInfoContributor(value="actors")
@AutoConfigureAfter(value={OrbitSpringConfiguration.class})
@EnableConfigurationProperties(value={GroupProperties.class})
public class ActorInfoContributorConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ActorInfoContributorLifetimeExtension.class})
    public ActorInfoContributorLifetimeExtension actorInfoContributorLifetimeExtension(@Qualifier(value="stageExecutorService") ExecutorService stageExecutorService, GroupProperties groupProperties) {
        return new ActorInfoContributorLifetimeExtension(RemoteReference::getInterfaceClass, new ActorInfoDetailsContainer(groupProperties), stageExecutorService);
    }

    @ConfigurationProperties(prefix="management.info.actors.group")
    static class GroupProperties {
        private GroupType primary = GroupType.INTERFACE;
        private GroupType secondary = GroupType.IDENTITY;

        GroupProperties() {
        }

        public GroupType getPrimary() {
            return this.primary;
        }

        public GroupType getSecondary() {
            return this.secondary;
        }

        public void setPrimary(GroupType primary) {
            this.primary = primary;
        }

        public void setSecondary(GroupType secondary) {
            this.secondary = secondary;
        }

        public String toString() {
            return "GroupProperties{primary=" + (Object)((Object)this.primary) + ", secondary=" + (Object)((Object)this.secondary) + '}';
        }

        static enum GroupType {
            NONE,
            INTERFACE,
            IDENTITY;

        }
    }
}

