/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.spring.actuate;

import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.concurrent.Task;
import cloud.orbit.spring.actuate.ActorInfoContributorReference;
import cloud.orbit.spring.actuate.ActorInfoDetailsContainer;
import cloud.orbit.spring.actuate.AsyncLifetimeExtension;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;

public class ActorInfoContributorLifetimeExtension
extends AsyncLifetimeExtension
implements InfoContributor {
    private static final Logger log = LoggerFactory.getLogger(ActorInfoContributorLifetimeExtension.class);
    private final Function<AbstractActor, Class> actorTypeResolver;
    private final ActorInfoDetailsContainer actorInfoDetailsContainer;
    private final Set<ActorInfoContributorReference> actorInfoContributorReferences = new HashSet<ActorInfoContributorReference>();

    ActorInfoContributorLifetimeExtension(Function<AbstractActor, Class> actorTypeResolver, ActorInfoDetailsContainer actorInfoDetailsContainer, Executor executor) {
        super(executor);
        this.actorTypeResolver = actorTypeResolver;
        this.actorInfoDetailsContainer = actorInfoDetailsContainer;
    }

    public Task<?> postActivationAsync(AbstractActor<?> actor) {
        return this.doIfInfoContributor(actor, this.actorInfoContributorReferences::add);
    }

    public Task<?> postDeactivationAsync(AbstractActor<?> actor) {
        return this.doIfInfoContributor(actor, this.actorInfoContributorReferences::remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<?> doIfInfoContributor(AbstractActor<?> actor, Consumer<ActorInfoContributorReference> synchronizedAction) {
        if (actor instanceof InfoContributor) {
            ActorInfoContributorReference actorInfoContributorReference = new ActorInfoContributorReference(this.actorTypeResolver, actor);
            Set<ActorInfoContributorReference> set = this.actorInfoContributorReferences;
            synchronized (set) {
                synchronizedAction.accept(actorInfoContributorReference);
            }
        }
        return Task.done();
    }

    public void contribute(Info.Builder builder) {
        this.populateActorInfoContainerWhileRemovingExpiredReferences();
        Map<String, Object> details = this.actorInfoDetailsContainer.getDetailsSnapshot();
        if (!details.isEmpty()) {
            builder.withDetail("actors", details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateActorInfoContainerWhileRemovingExpiredReferences() {
        Set<ActorInfoContributorReference> set = this.actorInfoContributorReferences;
        synchronized (set) {
            Iterator<ActorInfoContributorReference> it = this.actorInfoContributorReferences.iterator();
            while (it.hasNext()) {
                try {
                    ActorInfoContributorReference actor = it.next();
                    this.actorInfoDetailsContainer.mergeDetailsFrom(actor);
                }
                catch (ActorInfoContributorReference.ExpiredReferenceException e) {
                    log.debug("Lost reference to actor", (Throwable)e);
                    it.remove();
                }
            }
        }
    }
}

