/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.spring.actuate;

import cloud.orbit.actors.Stage;
import cloud.orbit.actors.runtime.NodeCapabilities;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;

public class OrbitHealthIndicator
implements HealthIndicator {
    private final Stage stage;

    public OrbitHealthIndicator(Stage stage) {
        this.stage = stage;
    }

    public Health health() {
        if (this.stage == null) {
            return Health.down().build();
        }
        boolean alive = this.stage.getAllNodes().contains(this.stage.getLocalAddress());
        NodeCapabilities.NodeState state = this.stage.getState();
        Status status = alive && state == NodeCapabilities.NodeState.RUNNING ? Status.UP : Status.DOWN;
        return Health.status((Status)status).withDetail("state", (Object)state).withDetail("alive", (Object)alive).build();
    }
}

