/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.spring;

import cloud.orbit.actors.Stage;
import cloud.orbit.actors.cloner.ExecutionObjectCloner;
import cloud.orbit.actors.cluster.ClusterPeer;
import cloud.orbit.actors.extensions.ActorConstructionExtension;
import cloud.orbit.actors.extensions.ActorExtension;
import cloud.orbit.actors.extensions.MessageSerializer;
import cloud.orbit.actors.runtime.Execution;
import cloud.orbit.actors.runtime.InvocationHandler;
import cloud.orbit.actors.runtime.LocalObjectsCleaner;
import cloud.orbit.actors.runtime.Messaging;
import cloud.orbit.spring.OrbitActorsProperties;
import cloud.orbit.spring.OrbitSpringConfigurationAddon;
import cloud.orbit.spring.SpringActorConstructionExtension;
import java.time.Clock;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration
@EnableConfigurationProperties(value={OrbitActorsProperties.class})
public class OrbitSpringConfiguration {
    @Autowired(required=false)
    private List<OrbitSpringConfigurationAddon> configAddons;
    @Autowired(required=false)
    @Qualifier(value="stageClock")
    private Clock stageClock;
    @Autowired(required=false)
    @Qualifier(value="stageExecutorService")
    private ExecutorService stageExecutorService;
    @Autowired(required=false)
    private Execution execution;
    @Autowired(required=false)
    private LocalObjectsCleaner localObjectsCleaner;
    @Autowired(required=false)
    private ClusterPeer clusterPeer;
    @Autowired(required=false)
    @Qualifier(value="executionObjectCloner")
    private ExecutionObjectCloner executionObjectCloner;
    @Autowired(required=false)
    private MessageSerializer messageSerializer;
    @Autowired(required=false)
    @Qualifier(value="messageLoopbackObjectCloner")
    private ExecutionObjectCloner messageLoopbackObjectCloner;
    @Autowired(required=false)
    private InvocationHandler invocationHandler;
    @Autowired(required=false)
    @Qualifier(value="stageTimer")
    private Timer stageTimer;

    @Bean
    @ConditionalOnMissingBean(value={ActorConstructionExtension.class})
    public ActorConstructionExtension springActorConstructionExtension(AutowireCapableBeanFactory factory) {
        return new SpringActorConstructionExtension(factory);
    }

    @Bean
    @ConditionalOnMissingBean(value={Messaging.class})
    public Messaging messaging(OrbitActorsProperties properties) {
        Messaging messaging = new Messaging();
        if (properties.getMessagingTimeoutInMilliseconds() != null) {
            messaging.setResponseTimeoutMillis(properties.getMessagingTimeoutInMilliseconds().longValue());
        }
        return messaging;
    }

    @Bean
    @ConditionalOnMissingBean(value={Stage.class})
    public Stage stage(OrbitActorsProperties properties, List<ActorExtension> actorExtensions, Messaging messaging) {
        Stage stage = this.buildStage(properties, actorExtensions, messaging);
        if (this.configAddons != null) {
            this.configAddons.forEach(addon -> addon.configure(stage));
        }
        stage.start().join();
        stage.bind();
        return stage;
    }

    Stage buildStage(OrbitActorsProperties properties, List<ActorExtension> actorExtensions, Messaging messaging) {
        Assert.notNull((Object)properties);
        Stage.Builder stageBuilder = new Stage.Builder().clock(this.stageClock).executionPool(this.stageExecutorService).execution(this.execution).localObjectsCleaner(this.localObjectsCleaner).clusterPeer(this.clusterPeer).objectCloner(this.executionObjectCloner).messageSerializer(this.messageSerializer).messageLoopbackObjectCloner(this.messageLoopbackObjectCloner).messaging(messaging).invocationHandler(this.invocationHandler).timer(this.stageTimer).clusterName(properties.getClusterName()).nodeName(properties.getNodeName());
        if (actorExtensions != null) {
            stageBuilder.extensions(actorExtensions.toArray(new ActorExtension[actorExtensions.size()]));
        }
        if (properties.getBasePackages() != null) {
            stageBuilder.basePackages(properties.getBasePackages());
        }
        if (properties.getStageMode() != null) {
            stageBuilder.mode(properties.getStageMode());
        }
        if (properties.getTimeToLiveInSeconds() != null) {
            stageBuilder.actorTTL(properties.getTimeToLiveInSeconds().longValue(), TimeUnit.SECONDS);
        }
        if (properties.getStickyHeaders() != null) {
            properties.getStickyHeaders().forEach(xva$0 -> stageBuilder.stickyHeaders(new String[]{xva$0}));
        }
        if (properties.getConcurrentDeactivations() != null) {
            stageBuilder.concurrentDeactivations(properties.getConcurrentDeactivations().intValue());
        }
        if (properties.getDeactivationTimeoutInMilliseconds() != null) {
            stageBuilder.deactivationTimeout(properties.getDeactivationTimeoutInMilliseconds().longValue(), TimeUnit.MILLISECONDS);
        }
        if (properties.getExecutionPoolSize() != null) {
            stageBuilder.executionPoolSize(properties.getExecutionPoolSize().intValue());
        }
        return stageBuilder.build();
    }
}

