/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.spring;

import cloud.orbit.actors.extensions.LifetimeExtension;
import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.concurrent.Task;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

class SpringLifetimeExtension
implements LifetimeExtension {
    private final AutowireCapableBeanFactory beanFactory;

    public SpringLifetimeExtension(AutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public <T> T newInstance(Class<T> concreteClass) {
        return (T)this.beanFactory.createBean(concreteClass);
    }

    public Task<Void> preActivation(AbstractActor<?> actor) {
        this.beanFactory.autowireBeanProperties(actor, 2, false);
        return Task.done();
    }
}

