/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.spring;

import cloud.orbit.actors.Stage;
import cloud.orbit.actors.extensions.ActorExtension;
import cloud.orbit.actors.runtime.Messaging;
import cloud.orbit.spring.OrbitActorsProperties;
import cloud.orbit.spring.OrbitSpringConfigurationAddon;
import cloud.orbit.spring.SpringLifetimeExtension;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OrbitActorsProperties.class})
public class OrbitSpringConfiguration {
    @Autowired(required=false)
    private List<OrbitSpringConfigurationAddon> configAddons;

    @Bean
    public ActorExtension springLifecycleExtension(AutowireCapableBeanFactory factory) {
        return new SpringLifetimeExtension(factory);
    }

    @Bean
    public Stage stage(OrbitActorsProperties properties, List<ActorExtension> actorExtensions) {
        Stage.Builder stageBuilder = new Stage.Builder().extensions(actorExtensions.toArray(new ActorExtension[actorExtensions.size()]));
        if (properties.getBasePackages() != null) {
            stageBuilder.basePackages(properties.getBasePackages());
        }
        if (properties.getClusterName() != null) {
            stageBuilder.clusterName(properties.getClusterName());
        }
        if (properties.getNodeName() != null) {
            stageBuilder.nodeName(properties.getNodeName());
        }
        if (properties.getStageMode() != null) {
            stageBuilder.mode(properties.getStageMode());
        }
        if (properties.getTimeToLiveInSeconds() != null) {
            stageBuilder.actorTTL(properties.getTimeToLiveInSeconds().longValue(), TimeUnit.SECONDS);
        }
        if (properties.getMessagingTimeoutInMilliseconds() != null) {
            Messaging orbitMessaging = new Messaging();
            orbitMessaging.setResponseTimeoutMillis(properties.getMessagingTimeoutInMilliseconds().longValue());
            stageBuilder.messaging(orbitMessaging);
        }
        if (properties.getStickyHeaders() != null) {
            properties.getStickyHeaders().forEach(xva$0 -> stageBuilder.stickyHeaders(new String[]{xva$0}));
        }
        if (properties.getConcurrentDeactivations() != null) {
            stageBuilder.concurrentDeactivations(properties.getConcurrentDeactivations().intValue());
        }
        if (properties.getDeactivationTimeoutInMilliseconds() != null) {
            stageBuilder.deactivationTimeout(properties.getDeactivationTimeoutInMilliseconds().longValue(), TimeUnit.MILLISECONDS);
        }
        Stage stage = stageBuilder.build();
        if (properties.getExecutionPoolSize() != null) {
            stage.setExecutionPoolSize(properties.getExecutionPoolSize().intValue());
        }
        if (this.configAddons != null) {
            this.configAddons.forEach(addon -> addon.configure(stage));
        }
        stage.start().join();
        stage.bind();
        return stage;
    }
}

