/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.spring;

import cloud.orbit.actors.Stage;
import cloud.orbit.actors.extensions.ActorExtension;
import cloud.orbit.actors.runtime.Messaging;
import cloud.orbit.spring.OrbitActorsProperties;
import cloud.orbit.spring.OrbitSpringConfigurationAddon;
import cloud.orbit.spring.SpringLifetimeExtension;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OrbitActorsProperties.class})
public class OrbitSpringConfiguration {
    @Autowired
    AutowireCapableBeanFactory factory;
    @Autowired(required=false)
    List<OrbitSpringConfigurationAddon> configAddons;

    @Bean
    public Stage stage(OrbitActorsProperties properties) {
        Stage.Builder stageBuilder = new Stage.Builder().extensions(new ActorExtension[]{new SpringLifetimeExtension(this.factory)});
        if (properties.getClusterName() != null) {
            stageBuilder.clusterName(properties.getClusterName());
        }
        if (properties.getNodeName() != null) {
            stageBuilder.nodeName(properties.getNodeName());
        }
        if (properties.getStageMode() != null) {
            stageBuilder.mode(properties.getStageMode());
        }
        if (properties.getTimeToLiveInSeconds() != null) {
            stageBuilder.actorTTL(properties.getTimeToLiveInSeconds().longValue(), TimeUnit.SECONDS);
        }
        if (properties.getMessagingTimeoutInMilliseconds() != null) {
            Messaging orbitMessaging = new Messaging();
            orbitMessaging.setResponseTimeoutMillis(properties.getMessagingTimeoutInMilliseconds().longValue());
            stageBuilder.messaging(orbitMessaging);
        }
        if (properties.getStickyHeaders() != null) {
            properties.getStickyHeaders().forEach(xva$0 -> stageBuilder.stickyHeaders(new String[]{xva$0}));
        }
        Stage stage = stageBuilder.build();
        if (this.configAddons != null) {
            this.configAddons.forEach(addon -> addon.configure(stage));
        }
        stage.start().join();
        stage.bind();
        return stage;
    }
}

