/*
 * Decompiled with CFR 0.152.
 */
package orbit.server.service;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import orbit.server.mesh.LocalServerInfo;
import orbit.server.service.AddressableManagementService;
import orbit.server.service.ConnectionService;
import orbit.server.service.GrpcEndpoint;
import orbit.server.service.HealthService;
import orbit.server.service.NodeManagementService;
import orbit.server.service.ServerAuthInterceptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorbit/server/service/GrpcEndpoint;", "", "serverAuthInterceptor", "Lorbit/server/service/ServerAuthInterceptor;", "healthService", "Lorbit/server/service/HealthService;", "nodeManagementService", "Lorbit/server/service/NodeManagementService;", "addressableManagementService", "Lorbit/server/service/AddressableManagementService;", "connectionService", "Lorbit/server/service/ConnectionService;", "localServerInfo", "Lorbit/server/mesh/LocalServerInfo;", "(Lorbit/server/service/ServerAuthInterceptor;Lorbit/server/service/HealthService;Lorbit/server/service/NodeManagementService;Lorbit/server/service/AddressableManagementService;Lorbit/server/service/ConnectionService;Lorbit/server/mesh/LocalServerInfo;)V", "logger", "Lmu/KLogger;", "server", "Lio/grpc/Server;", "start", "", "stop", "orbit-server"})
public final class GrpcEndpoint {
    private final KLogger logger;
    private Server server;
    private final ServerAuthInterceptor serverAuthInterceptor;
    private final HealthService healthService;
    private final NodeManagementService nodeManagementService;
    private final AddressableManagementService addressableManagementService;
    private final ConnectionService connectionService;
    private final LocalServerInfo localServerInfo;

    public final void start() {
        this.logger.info("Starting gRPC Endpoint on " + this.localServerInfo + ".port...");
        Server server = ServerBuilder.forPort((int)this.localServerInfo.getPort()).intercept((ServerInterceptor)this.serverAuthInterceptor).addService((BindableService)this.healthService).addService((BindableService)this.nodeManagementService).addService((BindableService)this.addressableManagementService).addService((BindableService)this.connectionService).build().start();
        Intrinsics.checkExpressionValueIsNotNull((Object)server, (String)"ServerBuilder.forPort(lo\u2026ld()\n            .start()");
        this.server = server;
        this.logger.info("gRPC Endpoint started on " + this.localServerInfo + ".port.");
    }

    public final void stop() {
        Server server = this.server;
        if (server == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"server");
        }
        server.shutdownNow().awaitTermination();
    }

    public GrpcEndpoint(@NotNull ServerAuthInterceptor serverAuthInterceptor, @NotNull HealthService healthService, @NotNull NodeManagementService nodeManagementService, @NotNull AddressableManagementService addressableManagementService, @NotNull ConnectionService connectionService, @NotNull LocalServerInfo localServerInfo) {
        Intrinsics.checkParameterIsNotNull((Object)serverAuthInterceptor, (String)"serverAuthInterceptor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)healthService), (String)"healthService");
        Intrinsics.checkParameterIsNotNull((Object)((Object)nodeManagementService), (String)"nodeManagementService");
        Intrinsics.checkParameterIsNotNull((Object)((Object)addressableManagementService), (String)"addressableManagementService");
        Intrinsics.checkParameterIsNotNull((Object)((Object)connectionService), (String)"connectionService");
        Intrinsics.checkParameterIsNotNull((Object)localServerInfo, (String)"localServerInfo");
        this.serverAuthInterceptor = serverAuthInterceptor;
        this.healthService = healthService;
        this.nodeManagementService = nodeManagementService;
        this.addressableManagementService = addressableManagementService;
        this.connectionService = connectionService;
        this.localServerInfo = localServerInfo;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }
}

