/*
 * Decompiled with CFR 0.152.
 */
package orbit.server.mesh;

import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import orbit.server.OrbitServerConfig;
import orbit.server.mesh.ClusterManager;
import orbit.server.mesh.LeaseDuration;
import orbit.server.mesh.NodeDirectory;
import orbit.shared.exception.InvalidChallengeException;
import orbit.shared.exception.InvalidNodeId;
import orbit.shared.mesh.NodeCapabilities;
import orbit.shared.mesh.NodeId;
import orbit.shared.mesh.NodeInfo;
import orbit.shared.mesh.NodeLease;
import orbit.util.misc.RNGUtils;
import orbit.util.time.Timestamp;
import orbit.util.time.TimestampKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017J%\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ-\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J-\u0010$\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\t2\n\u0010%\u001a\u00060\u001fj\u0002`&2\u0006\u0010 \u001a\u00020!H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0011\u0010(\u001a\u00020)H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J3\u0010+\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\t2\u0016\u0010,\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n0-H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006/"}, d2={"Lorbit/server/mesh/ClusterManager;", "", "config", "Lorbit/server/OrbitServerConfig;", "nodeDirectory", "Lorbit/server/mesh/NodeDirectory;", "(Lorbit/server/OrbitServerConfig;Lorbit/server/mesh/NodeDirectory;)V", "clusterNodes", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorbit/shared/mesh/NodeId;", "Lorbit/shared/mesh/NodeInfo;", "leaseExpiration", "Lorbit/server/mesh/LeaseDuration;", "nodeGraph", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jgrapht/Graph;", "Lorg/jgrapht/graph/DefaultEdge;", "buildGraph", "findRoute", "", "sourceNode", "targetNode", "getAllNodes", "", "getNode", "nodeId", "forceRefresh", "", "(Lorbit/shared/mesh/NodeId;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "joinCluster", "namespace", "", "capabilities", "Lorbit/shared/mesh/NodeCapabilities;", "url", "(Ljava/lang/String;Lorbit/shared/mesh/NodeCapabilities;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renewLease", "challengeToken", "Lorbit/shared/mesh/ChallengeToken;", "(Lorbit/shared/mesh/NodeId;Ljava/lang/String;Lorbit/shared/mesh/NodeCapabilities;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tick", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateNode", "body", "Lkotlin/Function1;", "(Lorbit/shared/mesh/NodeId;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "orbit-server"})
public final class ClusterManager {
    private final LeaseDuration leaseExpiration;
    private final ConcurrentHashMap<NodeId, NodeInfo> clusterNodes;
    private final AtomicReference<Graph<NodeId, DefaultEdge>> nodeGraph;
    private final NodeDirectory nodeDirectory;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<NodeInfo> getAllNodes() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.clusterNodes;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var6_6 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!((NodeInfo)it.getValue()).getLease().getExpiresAt().inFuture()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv.values();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object tick(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof tick.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ClusterManager this$0;
                Object L$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.tick((Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = clusterManager;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.nodeDirectory.entries((Continuation)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (ClusterManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                allNodes = (Iterable)v0;
                this.clusterNodes.clear();
                MapsKt.putAll((Map)this.clusterNodes, (Iterable)allNodes);
                this.buildGraph();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object joinCluster(@NotNull String namespace, @NotNull NodeCapabilities capabilities, @Nullable String url, @NotNull Continuation<? super NodeInfo> $completion) {
        if (!($completion instanceof joinCluster.1)) ** GOTO lbl-1000
        var12_5 = $completion;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ClusterManager this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.joinCluster(null, null, null, (Continuation<? super NodeInfo>)this);
                }
                {
                    this.this$0 = clusterManager;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                while (true) {
                    newNodeId = NodeId.Companion.generate(namespace);
                    v0 = RNGUtils.randomString$default((RNGUtils)RNGUtils.INSTANCE, (int)64, null, (int)2, null);
                    v1 = Instant.now().plus(this.leaseExpiration.getExpiresIn());
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"Instant.now().plus(leaseExpiration.expiresIn)");
                    v2 = TimestampKt.toTimestamp((Instant)v1);
                    v3 = Instant.now().plus(this.leaseExpiration.getRenewIn());
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"Instant.now().plus(leaseExpiration.renewIn)");
                    lease = new NodeLease(v0, v2, TimestampKt.toTimestamp((Instant)v3));
                    var8_13 = null;
                    var9_14 = url;
                    var10_15 = lease;
                    info = new NodeInfo(newNodeId, capabilities, var9_14, var10_15, var8_13, 16, null);
                    $continuation.L$0 = this;
                    $continuation.L$1 = namespace;
                    $continuation.L$2 = capabilities;
                    $continuation.L$3 = url;
                    $continuation.L$4 = newNodeId;
                    $continuation.L$5 = lease;
                    $continuation.L$6 = info;
                    $continuation.label = 1;
                    v4 = this.nodeDirectory.compareAndSet(newNodeId, null, info, (Continuation)$continuation);
                    if (v4 != var13_7) continue;
                    return var13_7;
                }
            }
            case 1: {
                info = (NodeInfo)$continuation.L$6;
                lease = (NodeLease)$continuation.L$5;
                newNodeId = (NodeId)$continuation.L$4;
                url = (String)$continuation.L$3;
                capabilities = (NodeCapabilities)$continuation.L$2;
                namespace = (String)$continuation.L$1;
                this = (ClusterManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
                if (!((Boolean)v4).booleanValue()) ** continue;
                $continuation.L$0 = this;
                $continuation.L$1 = namespace;
                $continuation.L$2 = capabilities;
                $continuation.L$3 = url;
                $continuation.L$4 = newNodeId;
                $continuation.L$5 = lease;
                $continuation.L$6 = info;
                $continuation.label = 2;
                v5 = this.tick((Continuation<? super Unit>)$continuation);
                if (v5 == var13_7) {
                    return var13_7;
                }
                ** GOTO lbl69
            }
            case 2: {
                info = (NodeInfo)$continuation.L$6;
                lease = (NodeLease)$continuation.L$5;
                newNodeId = (NodeId)$continuation.L$4;
                url = (String)$continuation.L$3;
                capabilities = (NodeCapabilities)$continuation.L$2;
                namespace = (String)$continuation.L$1;
                this = (ClusterManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl69:
                // 2 sources

                return info;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object joinCluster$default(ClusterManager clusterManager, String string, NodeCapabilities nodeCapabilities, String string2, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return clusterManager.joinCluster(string, nodeCapabilities, string2, (Continuation<? super NodeInfo>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object renewLease(@NotNull NodeId nodeId, @NotNull String challengeToken, @NotNull NodeCapabilities capabilities, @NotNull Continuation<? super NodeInfo> $completion) {
        if (!($completion instanceof renewLease.1)) ** GOTO lbl-1000
        var11_5 = $completion;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ClusterManager this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.renewLease(null, null, null, (Continuation<? super NodeInfo>)this);
                }
                {
                    this.this$0 = clusterManager;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = nodeId;
                $continuation.L$2 = challengeToken;
                $continuation.L$3 = capabilities;
                $continuation.label = 1;
                v0 = this.updateNode(nodeId, (Function1<? super NodeInfo, NodeInfo>)((Function1)new Function1<NodeInfo, NodeInfo>(this, nodeId, challengeToken, capabilities){
                    final /* synthetic */ ClusterManager this$0;
                    final /* synthetic */ NodeId $nodeId;
                    final /* synthetic */ String $challengeToken;
                    final /* synthetic */ NodeCapabilities $capabilities;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final NodeInfo invoke(@Nullable NodeInfo initialValue) {
                        void var2_2;
                        if (initialValue == null || Timestamp.Companion.now().compareTo(initialValue.getLease().getExpiresAt()) > 0) {
                            throw (Throwable)new InvalidNodeId(this.$nodeId);
                        }
                        if (Intrinsics.areEqual((Object)initialValue.getLease().getChallengeToken(), (Object)this.$challengeToken) ^ true) {
                            throw (Throwable)new InvalidChallengeException(this.$nodeId, this.$challengeToken);
                        }
                        NodeLease nodeLease = initialValue.getLease();
                        Instant instant = Instant.now().plus(ClusterManager.access$getLeaseExpiration$p(this.this$0).getExpiresIn());
                        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now().plus(leaseExpiration.expiresIn)");
                        Timestamp timestamp = TimestampKt.toTimestamp((Instant)instant);
                        Instant instant2 = Instant.now().plus(ClusterManager.access$getLeaseExpiration$p(this.this$0).getRenewIn());
                        Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"Instant.now().plus(leaseExpiration.renewIn)");
                        NodeInfo newValue = NodeInfo.copy$default((NodeInfo)initialValue, null, (NodeCapabilities)this.$capabilities, null, (NodeLease)NodeLease.copy$default((NodeLease)nodeLease, null, (Timestamp)timestamp, (Timestamp)TimestampKt.toTimestamp((Instant)instant2), (int)1, null), null, (int)21, null);
                        return var2_2;
                    }
                    {
                        this.this$0 = clusterManager;
                        this.$nodeId = nodeId;
                        this.$challengeToken = string;
                        this.$capabilities = nodeCapabilities;
                        super(1);
                    }
                }), (Continuation<? super NodeInfo>)$continuation);
                if (v0 == var12_7) {
                    return var12_7;
                }
                ** GOTO lbl28
            }
            case 1: {
                capabilities = (NodeCapabilities)$continuation.L$3;
                challengeToken = (String)$continuation.L$2;
                nodeId = (NodeId)$continuation.L$1;
                this = (ClusterManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                var5_8 = v0;
                var6_9 = false;
                var7_10 = false;
                it = (NodeInfo)var5_8;
                $i$a$-also-ClusterManager$renewLease$3 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = nodeId;
                $continuation.L$2 = challengeToken;
                $continuation.L$3 = capabilities;
                $continuation.L$4 = var5_8;
                $continuation.L$5 = it;
                $continuation.label = 2;
                v1 = this.tick((Continuation<? super Unit>)$continuation);
                if (v1 == var12_7) {
                    return var12_7;
                }
                ** GOTO lbl55
            }
            case 2: {
                it = (NodeInfo)$continuation.L$5;
                var5_8 = $continuation.L$4;
                capabilities = (NodeCapabilities)$continuation.L$3;
                challengeToken = (String)$continuation.L$2;
                nodeId = (NodeId)$continuation.L$1;
                this = (ClusterManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl55:
                // 2 sources

                return var5_8;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object updateNode(@NotNull NodeId nodeId, @NotNull Function1<? super NodeInfo, NodeInfo> body, @NotNull Continuation<? super NodeInfo> $completion) {
        if (!($completion instanceof updateNode.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ClusterManager this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateNode(null, null, (Continuation<? super NodeInfo>)this);
                }
                {
                    this.this$0 = clusterManager;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = nodeId;
                $continuation.L$2 = body;
                $continuation.label = 1;
                v0 = this.nodeDirectory.manipulate(nodeId, body, (Continuation)$continuation);
                if (v0 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                body = (Function1)$continuation.L$2;
                nodeId = (NodeId)$continuation.L$1;
                this = (ClusterManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                var4_7 = v0;
                var5_8 = false;
                var6_9 = false;
                it = (NodeInfo)var4_7;
                $i$a$-also-ClusterManager$updateNode$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = nodeId;
                $continuation.L$2 = body;
                $continuation.L$3 = var4_7;
                $continuation.L$4 = it;
                $continuation.label = 2;
                v1 = this.tick((Continuation<? super Unit>)$continuation);
                if (v1 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl49
            }
            case 2: {
                it = (NodeInfo)$continuation.L$4;
                var4_7 = $continuation.L$3;
                body = (Function1)$continuation.L$2;
                nodeId = (NodeId)$continuation.L$1;
                this = (ClusterManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl49:
                // 2 sources

                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object getNode(@NotNull NodeId nodeId, boolean forceRefresh, @NotNull Continuation<? super NodeInfo> $completion) {
        if (!($completion instanceof getNode.1)) ** GOTO lbl-1000
        var13_4 = $completion;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ClusterManager this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                boolean Z$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getNode(null, false, (Continuation<? super NodeInfo>)this);
                }
                {
                    this.this$0 = clusterManager;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!forceRefresh) break;
                $continuation.L$0 = this;
                $continuation.L$1 = nodeId;
                $continuation.Z$0 = forceRefresh;
                $continuation.label = 1;
                v0 = this.nodeDirectory.get(nodeId, (Continuation)$continuation);
                if (v0 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl27
            }
            case 1: {
                forceRefresh = $continuation.Z$0;
                nodeId = (NodeId)$continuation.L$1;
                this = (ClusterManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                v1 = (NodeInfo)v0;
                ** GOTO lbl67
            }
        }
        $this$getOrPut$iv = this.clusterNodes;
        $i$f$getOrPut = false;
        v2 /* !! */  = $this$getOrPut$iv.get(nodeId);
        if (v2 /* !! */  != null) ** GOTO lbl62
        $i$a$-getOrPut-ClusterManager$getNode$2 = false;
        $continuation.L$0 = this;
        $continuation.L$1 = nodeId;
        $continuation.Z$0 = forceRefresh;
        $continuation.L$2 = $this$getOrPut$iv;
        $continuation.label = 2;
        v3 = this.nodeDirectory.get(nodeId, (Continuation)$continuation);
        ** if (v3 != var14_6) goto lbl44
lbl43:
        // 1 sources

        return var14_6;
lbl44:
        // 1 sources

        ** GOTO lbl53
        {
            case 2: {
                $this$getOrPut$iv = (ConcurrentMap)$continuation.L$2;
                forceRefresh = $continuation.Z$0;
                nodeId = (NodeId)$continuation.L$1;
                this = (ClusterManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl53:
                    // 2 sources

                    var7_11 = (NodeInfo)v3;
                    var8_12 = false;
                    var9_13 = false;
                    default$iv = var7_11;
                    $i$a$-let-MapsKt__MapsJVMKt$getOrPut$1$iv = false;
                    v2 /* !! */  = $this$getOrPut$iv.putIfAbsent(nodeId, default$iv);
                    if (v2 /* !! */  == null) {
                        v2 /* !! */  = default$iv;
                    }
lbl62:
                    // 4 sources

                    var4_7 = (NodeInfo)v2 /* !! */ ;
                }
                catch (NullPointerException t) {
                    var4_7 = null;
                }
                v1 = var4_7;
lbl67:
                // 2 sources

                if (v1 != null) {
                    var4_7 = v1;
                    var5_8 = false;
                    var6_10 = false;
                    it = var4_7;
                    $i$a$-let-ClusterManager$getNode$3 = false;
                    v4 /* !! */  = it.getLease().getExpiresAt().inFuture() ? it : null;
                } else {
                    v4 /* !! */  = null;
                }
                return v4 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object getNode$default(ClusterManager clusterManager, NodeId nodeId, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return clusterManager.getNode(nodeId, bl, (Continuation<? super NodeInfo>)continuation);
    }

    @NotNull
    public final List<NodeId> findRoute(@NotNull NodeId sourceNode, @NotNull NodeId targetNode) {
        GraphPath path;
        Object object;
        Graph<NodeId, DefaultEdge> graph;
        Intrinsics.checkParameterIsNotNull((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkParameterIsNotNull((Object)targetNode, (String)"targetNode");
        Graph<NodeId, DefaultEdge> graph2 = this.nodeGraph.get();
        if (graph2 == null) {
            graph2 = graph = this.buildGraph();
        }
        if ((object = (path = DijkstraShortestPath.findPathBetween(graph, (Object)sourceNode, (Object)targetNode))) == null || (object = object.getVertexList()) == null || (object = CollectionsKt.drop((Iterable)((Iterable)object), (int)1)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final Graph<NodeId, DefaultEdge> buildGraph() {
        NodeInfo node;
        DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
        Collection<NodeInfo> collection = this.clusterNodes.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"clusterNodes.values");
        Collection<NodeInfo> nodes = collection;
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            node = (NodeInfo)element$iv;
            boolean bl = false;
            graph.addVertex((Object)node.getId());
        }
        $this$forEach$iv = nodes;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            node = (NodeInfo)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = node.getVisibleNodes();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                NodeId visibleNode = (NodeId)element$iv2;
                boolean bl2 = false;
                graph.addEdge((Object)node.getId(), (Object)visibleNode);
            }
        }
        this.nodeGraph.set((Graph<NodeId, DefaultEdge>)graph);
        return (Graph)graph;
    }

    public ClusterManager(@NotNull OrbitServerConfig config, @NotNull NodeDirectory nodeDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)nodeDirectory, (String)"nodeDirectory");
        this.nodeDirectory = nodeDirectory;
        this.leaseExpiration = config.getNodeLeaseDuration();
        this.clusterNodes = new ConcurrentHashMap();
        this.nodeGraph = new AtomicReference();
    }

    public static final /* synthetic */ LeaseDuration access$getLeaseExpiration$p(ClusterManager $this) {
        return $this.leaseExpiration;
    }
}

