/*
 * Decompiled with CFR 0.152.
 */
package orbit.server;

import java.net.URI;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import orbit.server.mesh.AddressableDirectory;
import orbit.server.mesh.LeaseDuration;
import orbit.server.mesh.LocalServerInfo;
import orbit.server.mesh.NodeDirectory;
import orbit.server.mesh.local.LocalAddressableDirectory;
import orbit.server.mesh.local.LocalNodeDirectory;
import orbit.util.concurrent.Pools;
import orbit.util.di.ExternallyConfigured;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u007f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012\u00a2\u0006\u0002\u0010\u0016J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003J\t\u0010/\u001a\u00020\nH\u00c6\u0003J\t\u00100\u001a\u00020\nH\u00c6\u0003J\t\u00101\u001a\u00020\rH\u00c6\u0003J\t\u00102\u001a\u00020\rH\u00c6\u0003J\t\u00103\u001a\u00020\u0010H\u00c6\u0003J\u0083\u0001\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u00c6\u0001J\u0013\u00105\u001a\u00020\u00102\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00107\u001a\u00020\u0007H\u00d6\u0001J\t\u00108\u001a\u000209H\u00d6\u0001R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006:"}, d2={"Lorbit/server/OrbitServerConfig;", "", "serverInfo", "Lorbit/server/mesh/LocalServerInfo;", "tickRate", "Ljava/time/Duration;", "pipelineRailCount", "", "pipelineBufferCount", "nodeLeaseDuration", "Lorbit/server/mesh/LeaseDuration;", "addressableLeaseDuration", "cpuPool", "Lkotlinx/coroutines/CoroutineDispatcher;", "ioPool", "acquireShutdownLatch", "", "nodeDirectory", "Lorbit/util/di/ExternallyConfigured;", "Lorbit/server/mesh/NodeDirectory;", "addressableDirectory", "Lorbit/server/mesh/AddressableDirectory;", "(Lorbit/server/mesh/LocalServerInfo;Ljava/time/Duration;IILorbit/server/mesh/LeaseDuration;Lorbit/server/mesh/LeaseDuration;Lkotlinx/coroutines/CoroutineDispatcher;Lkotlinx/coroutines/CoroutineDispatcher;ZLorbit/util/di/ExternallyConfigured;Lorbit/util/di/ExternallyConfigured;)V", "getAcquireShutdownLatch", "()Z", "getAddressableDirectory", "()Lorbit/util/di/ExternallyConfigured;", "getAddressableLeaseDuration", "()Lorbit/server/mesh/LeaseDuration;", "getCpuPool", "()Lkotlinx/coroutines/CoroutineDispatcher;", "getIoPool", "getNodeDirectory", "getNodeLeaseDuration", "getPipelineBufferCount", "()I", "getPipelineRailCount", "getServerInfo", "()Lorbit/server/mesh/LocalServerInfo;", "getTickRate", "()Ljava/time/Duration;", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "", "orbit-server"})
public final class OrbitServerConfig {
    @NotNull
    private final LocalServerInfo serverInfo;
    @NotNull
    private final Duration tickRate;
    private final int pipelineRailCount;
    private final int pipelineBufferCount;
    @NotNull
    private final LeaseDuration nodeLeaseDuration;
    @NotNull
    private final LeaseDuration addressableLeaseDuration;
    @NotNull
    private final CoroutineDispatcher cpuPool;
    @NotNull
    private final CoroutineDispatcher ioPool;
    private final boolean acquireShutdownLatch;
    @NotNull
    private final ExternallyConfigured<NodeDirectory> nodeDirectory;
    @NotNull
    private final ExternallyConfigured<AddressableDirectory> addressableDirectory;

    @NotNull
    public final LocalServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @NotNull
    public final Duration getTickRate() {
        return this.tickRate;
    }

    public final int getPipelineRailCount() {
        return this.pipelineRailCount;
    }

    public final int getPipelineBufferCount() {
        return this.pipelineBufferCount;
    }

    @NotNull
    public final LeaseDuration getNodeLeaseDuration() {
        return this.nodeLeaseDuration;
    }

    @NotNull
    public final LeaseDuration getAddressableLeaseDuration() {
        return this.addressableLeaseDuration;
    }

    @NotNull
    public final CoroutineDispatcher getCpuPool() {
        return this.cpuPool;
    }

    @NotNull
    public final CoroutineDispatcher getIoPool() {
        return this.ioPool;
    }

    public final boolean getAcquireShutdownLatch() {
        return this.acquireShutdownLatch;
    }

    @NotNull
    public final ExternallyConfigured<NodeDirectory> getNodeDirectory() {
        return this.nodeDirectory;
    }

    @NotNull
    public final ExternallyConfigured<AddressableDirectory> getAddressableDirectory() {
        return this.addressableDirectory;
    }

    public OrbitServerConfig(@NotNull LocalServerInfo serverInfo, @NotNull Duration tickRate, int pipelineRailCount, int pipelineBufferCount, @NotNull LeaseDuration nodeLeaseDuration, @NotNull LeaseDuration addressableLeaseDuration, @NotNull CoroutineDispatcher cpuPool, @NotNull CoroutineDispatcher ioPool, boolean acquireShutdownLatch, @NotNull ExternallyConfigured<NodeDirectory> nodeDirectory, @NotNull ExternallyConfigured<AddressableDirectory> addressableDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)serverInfo, (String)"serverInfo");
        Intrinsics.checkParameterIsNotNull((Object)tickRate, (String)"tickRate");
        Intrinsics.checkParameterIsNotNull((Object)nodeLeaseDuration, (String)"nodeLeaseDuration");
        Intrinsics.checkParameterIsNotNull((Object)addressableLeaseDuration, (String)"addressableLeaseDuration");
        Intrinsics.checkParameterIsNotNull((Object)cpuPool, (String)"cpuPool");
        Intrinsics.checkParameterIsNotNull((Object)ioPool, (String)"ioPool");
        Intrinsics.checkParameterIsNotNull(nodeDirectory, (String)"nodeDirectory");
        Intrinsics.checkParameterIsNotNull(addressableDirectory, (String)"addressableDirectory");
        this.serverInfo = serverInfo;
        this.tickRate = tickRate;
        this.pipelineRailCount = pipelineRailCount;
        this.pipelineBufferCount = pipelineBufferCount;
        this.nodeLeaseDuration = nodeLeaseDuration;
        this.addressableLeaseDuration = addressableLeaseDuration;
        this.cpuPool = cpuPool;
        this.ioPool = ioPool;
        this.acquireShutdownLatch = acquireShutdownLatch;
        this.nodeDirectory = nodeDirectory;
        this.addressableDirectory = addressableDirectory;
    }

    public /* synthetic */ OrbitServerConfig(LocalServerInfo localServerInfo, Duration duration, int n, int n2, LeaseDuration leaseDuration, LeaseDuration leaseDuration2, CoroutineDispatcher coroutineDispatcher, CoroutineDispatcher coroutineDispatcher2, boolean bl, ExternallyConfigured externallyConfigured, ExternallyConfigured externallyConfigured2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            String string;
            int n4;
            String string2 = System.getenv("ORBIT_PORT");
            if (string2 != null) {
                int n5;
                String string3 = string2;
                int n6 = 10;
                boolean bl2 = false;
                n4 = n5 = Integer.parseInt(string3, CharsKt.checkRadix((int)n6));
            } else {
                n4 = 50056;
            }
            if ((string = System.getenv("ORBIT_URL")) == null) {
                string = "localhost:50056";
            }
            URI uRI = new URI(string);
            int n7 = n4;
            localServerInfo = new LocalServerInfo(n7, uRI);
        }
        if ((n3 & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofSeconds(1)");
            duration = duration2;
        }
        if ((n3 & 4) != 0) {
            n = 128;
        }
        if ((n3 & 8) != 0) {
            n2 = 10000;
        }
        if ((n3 & 0x10) != 0) {
            Duration duration3 = Duration.ofSeconds(10L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofSeconds(10)");
            Duration duration4 = Duration.ofSeconds(5L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"Duration.ofSeconds(5)");
            leaseDuration = new LeaseDuration(duration3, duration4);
        }
        if ((n3 & 0x20) != 0) {
            Duration duration5 = Duration.ofMinutes(10L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration5, (String)"Duration.ofMinutes(10)");
            Duration duration6 = Duration.ofMinutes(5L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration6, (String)"Duration.ofMinutes(5)");
            leaseDuration2 = new LeaseDuration(duration5, duration6);
        }
        if ((n3 & 0x40) != 0) {
            coroutineDispatcher = Pools.createFixedPool$default((String)"orbit-cpu", (int)0, (int)2, null);
        }
        if ((n3 & 0x80) != 0) {
            coroutineDispatcher2 = Pools.createCachedPool((String)"orbit-io");
        }
        if ((n3 & 0x100) != 0) {
            bl = true;
        }
        if ((n3 & 0x200) != 0) {
            externallyConfigured = LocalNodeDirectory.LocalNodeDirectoryConfig.INSTANCE;
        }
        if ((n3 & 0x400) != 0) {
            externallyConfigured2 = LocalAddressableDirectory.LocalAddressableDirectoryConfig.INSTANCE;
        }
        this(localServerInfo, duration, n, n2, leaseDuration, leaseDuration2, coroutineDispatcher, coroutineDispatcher2, bl, (ExternallyConfigured<NodeDirectory>)externallyConfigured, (ExternallyConfigured<AddressableDirectory>)externallyConfigured2);
    }

    public OrbitServerConfig() {
        this(null, null, 0, 0, null, null, null, null, false, null, null, 2047, null);
    }

    @NotNull
    public final LocalServerInfo component1() {
        return this.serverInfo;
    }

    @NotNull
    public final Duration component2() {
        return this.tickRate;
    }

    public final int component3() {
        return this.pipelineRailCount;
    }

    public final int component4() {
        return this.pipelineBufferCount;
    }

    @NotNull
    public final LeaseDuration component5() {
        return this.nodeLeaseDuration;
    }

    @NotNull
    public final LeaseDuration component6() {
        return this.addressableLeaseDuration;
    }

    @NotNull
    public final CoroutineDispatcher component7() {
        return this.cpuPool;
    }

    @NotNull
    public final CoroutineDispatcher component8() {
        return this.ioPool;
    }

    public final boolean component9() {
        return this.acquireShutdownLatch;
    }

    @NotNull
    public final ExternallyConfigured<NodeDirectory> component10() {
        return this.nodeDirectory;
    }

    @NotNull
    public final ExternallyConfigured<AddressableDirectory> component11() {
        return this.addressableDirectory;
    }

    @NotNull
    public final OrbitServerConfig copy(@NotNull LocalServerInfo serverInfo, @NotNull Duration tickRate, int pipelineRailCount, int pipelineBufferCount, @NotNull LeaseDuration nodeLeaseDuration, @NotNull LeaseDuration addressableLeaseDuration, @NotNull CoroutineDispatcher cpuPool, @NotNull CoroutineDispatcher ioPool, boolean acquireShutdownLatch, @NotNull ExternallyConfigured<NodeDirectory> nodeDirectory, @NotNull ExternallyConfigured<AddressableDirectory> addressableDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)serverInfo, (String)"serverInfo");
        Intrinsics.checkParameterIsNotNull((Object)tickRate, (String)"tickRate");
        Intrinsics.checkParameterIsNotNull((Object)nodeLeaseDuration, (String)"nodeLeaseDuration");
        Intrinsics.checkParameterIsNotNull((Object)addressableLeaseDuration, (String)"addressableLeaseDuration");
        Intrinsics.checkParameterIsNotNull((Object)cpuPool, (String)"cpuPool");
        Intrinsics.checkParameterIsNotNull((Object)ioPool, (String)"ioPool");
        Intrinsics.checkParameterIsNotNull(nodeDirectory, (String)"nodeDirectory");
        Intrinsics.checkParameterIsNotNull(addressableDirectory, (String)"addressableDirectory");
        return new OrbitServerConfig(serverInfo, tickRate, pipelineRailCount, pipelineBufferCount, nodeLeaseDuration, addressableLeaseDuration, cpuPool, ioPool, acquireShutdownLatch, nodeDirectory, addressableDirectory);
    }

    public static /* synthetic */ OrbitServerConfig copy$default(OrbitServerConfig orbitServerConfig, LocalServerInfo localServerInfo, Duration duration, int n, int n2, LeaseDuration leaseDuration, LeaseDuration leaseDuration2, CoroutineDispatcher coroutineDispatcher, CoroutineDispatcher coroutineDispatcher2, boolean bl, ExternallyConfigured externallyConfigured, ExternallyConfigured externallyConfigured2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            localServerInfo = orbitServerConfig.serverInfo;
        }
        if ((n3 & 2) != 0) {
            duration = orbitServerConfig.tickRate;
        }
        if ((n3 & 4) != 0) {
            n = orbitServerConfig.pipelineRailCount;
        }
        if ((n3 & 8) != 0) {
            n2 = orbitServerConfig.pipelineBufferCount;
        }
        if ((n3 & 0x10) != 0) {
            leaseDuration = orbitServerConfig.nodeLeaseDuration;
        }
        if ((n3 & 0x20) != 0) {
            leaseDuration2 = orbitServerConfig.addressableLeaseDuration;
        }
        if ((n3 & 0x40) != 0) {
            coroutineDispatcher = orbitServerConfig.cpuPool;
        }
        if ((n3 & 0x80) != 0) {
            coroutineDispatcher2 = orbitServerConfig.ioPool;
        }
        if ((n3 & 0x100) != 0) {
            bl = orbitServerConfig.acquireShutdownLatch;
        }
        if ((n3 & 0x200) != 0) {
            externallyConfigured = orbitServerConfig.nodeDirectory;
        }
        if ((n3 & 0x400) != 0) {
            externallyConfigured2 = orbitServerConfig.addressableDirectory;
        }
        return orbitServerConfig.copy(localServerInfo, duration, n, n2, leaseDuration, leaseDuration2, coroutineDispatcher, coroutineDispatcher2, bl, externallyConfigured, externallyConfigured2);
    }

    @NotNull
    public String toString() {
        return "OrbitServerConfig(serverInfo=" + this.serverInfo + ", tickRate=" + this.tickRate + ", pipelineRailCount=" + this.pipelineRailCount + ", pipelineBufferCount=" + this.pipelineBufferCount + ", nodeLeaseDuration=" + this.nodeLeaseDuration + ", addressableLeaseDuration=" + this.addressableLeaseDuration + ", cpuPool=" + this.cpuPool + ", ioPool=" + this.ioPool + ", acquireShutdownLatch=" + this.acquireShutdownLatch + ", nodeDirectory=" + this.nodeDirectory + ", addressableDirectory=" + this.addressableDirectory + ")";
    }

    public int hashCode() {
        LocalServerInfo localServerInfo = this.serverInfo;
        Duration duration = this.tickRate;
        LeaseDuration leaseDuration = this.nodeLeaseDuration;
        LeaseDuration leaseDuration2 = this.addressableLeaseDuration;
        CoroutineDispatcher coroutineDispatcher = this.cpuPool;
        CoroutineDispatcher coroutineDispatcher2 = this.ioPool;
        int n = ((((((((localServerInfo != null ? ((Object)localServerInfo).hashCode() : 0) * 31 + (duration != null ? ((Object)duration).hashCode() : 0)) * 31 + Integer.hashCode(this.pipelineRailCount)) * 31 + Integer.hashCode(this.pipelineBufferCount)) * 31 + (leaseDuration != null ? ((Object)leaseDuration).hashCode() : 0)) * 31 + (leaseDuration2 != null ? ((Object)leaseDuration2).hashCode() : 0)) * 31 + (coroutineDispatcher != null ? coroutineDispatcher.hashCode() : 0)) * 31 + (coroutineDispatcher2 != null ? coroutineDispatcher2.hashCode() : 0)) * 31;
        int n2 = this.acquireShutdownLatch ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        ExternallyConfigured<NodeDirectory> externallyConfigured = this.nodeDirectory;
        ExternallyConfigured<AddressableDirectory> externallyConfigured2 = this.addressableDirectory;
        return ((n + n2) * 31 + (externallyConfigured != null ? externallyConfigured.hashCode() : 0)) * 31 + (externallyConfigured2 != null ? externallyConfigured2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof OrbitServerConfig)) break block3;
                OrbitServerConfig orbitServerConfig = (OrbitServerConfig)object;
                if (!Intrinsics.areEqual((Object)this.serverInfo, (Object)orbitServerConfig.serverInfo) || !Intrinsics.areEqual((Object)this.tickRate, (Object)orbitServerConfig.tickRate) || !(this.pipelineRailCount == orbitServerConfig.pipelineRailCount) || !(this.pipelineBufferCount == orbitServerConfig.pipelineBufferCount) || !Intrinsics.areEqual((Object)this.nodeLeaseDuration, (Object)orbitServerConfig.nodeLeaseDuration) || !Intrinsics.areEqual((Object)this.addressableLeaseDuration, (Object)orbitServerConfig.addressableLeaseDuration) || !Intrinsics.areEqual((Object)this.cpuPool, (Object)orbitServerConfig.cpuPool) || !Intrinsics.areEqual((Object)this.ioPool, (Object)orbitServerConfig.ioPool) || !(this.acquireShutdownLatch == orbitServerConfig.acquireShutdownLatch) || !Intrinsics.areEqual(this.nodeDirectory, orbitServerConfig.nodeDirectory) || !Intrinsics.areEqual(this.addressableDirectory, orbitServerConfig.addressableDirectory)) break block3;
            }
            return true;
        }
        return false;
    }
}

