/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.s3;

import cloud.orbit.actors.extensions.StorageExtension;
import cloud.orbit.actors.extensions.s3.S3Configuration;
import cloud.orbit.actors.extensions.s3.S3Connection;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.concurrent.Task;
import cloud.orbit.exception.UncheckedException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.S3Object;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class S3StorageExtension
implements StorageExtension {
    private String name = "default";
    private String bucketName = "orbit-test-bucket";
    private S3Configuration s3Configuration = new S3Configuration();
    private S3Connection s3Connection;

    public S3StorageExtension() {
    }

    public S3StorageExtension(S3Configuration s3Configuration) {
        this.s3Configuration = s3Configuration;
    }

    public Task<Void> start() {
        this.s3Connection = new S3Connection(this.s3Configuration);
        if (!this.s3Connection.getS3Client().doesBucketExist(this.bucketName)) {
            throw new UncheckedException("S3 bucket '" + this.bucketName + "' does not exist.");
        }
        return Task.done();
    }

    public Task<Void> stop() {
        return Task.done();
    }

    public Task<Void> clearState(RemoteReference<?> reference, Object state) {
        return Task.runAsync(() -> {
            String bucketName = this.getBucketName();
            String itemId = this.generateDocumentId(reference);
            this.s3Connection.getS3Client().deleteObject(bucketName, itemId);
        });
    }

    public Task<Boolean> readState(RemoteReference<?> reference, Object state) {
        return Task.supplyAsync(() -> {
            ObjectMapper mapper = this.s3Connection.getMapper();
            String bucketName = this.getBucketName();
            String itemId = this.generateDocumentId(reference);
            try {
                S3Object s3Object = this.s3Connection.getS3Client().getObject(bucketName, itemId);
                mapper.readerForUpdating(state).readValue((InputStream)s3Object.getObjectContent());
                s3Object.close();
                return Task.fromValue((Object)true);
            }
            catch (AmazonServiceException e) {
                String errorCode = e.getErrorCode();
                if (!errorCode.equals("NoSuchKey")) {
                    throw e;
                }
                return Task.fromValue((Object)false);
            }
            catch (Exception e) {
                throw new UncheckedException((Throwable)e);
            }
        });
    }

    public Task<Void> writeState(RemoteReference<?> reference, Object state) {
        return Task.runAsync(() -> {
            ObjectMapper mapper = this.s3Connection.getMapper();
            String bucketName = this.getBucketName();
            String itemId = this.generateDocumentId(reference);
            ByteArrayOutputStream fileStream = new ByteArrayOutputStream();
            try {
                mapper.writeValue((OutputStream)fileStream, state);
            }
            catch (IOException e) {
                throw new UncheckedException((Throwable)e);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileStream.toByteArray());
            this.s3Connection.getS3Client().putObject(bucketName, itemId, (InputStream)inputStream, null);
        });
    }

    public String generateDocumentId(RemoteReference<?> reference) {
        Class referenceClass = RemoteReference.getInterfaceClass(reference);
        String idDecoration = referenceClass.getSimpleName();
        String documentId = String.format("%s%s%s", idDecoration, "/", String.valueOf(RemoteReference.getId(reference)));
        return documentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public S3Configuration getS3Configuration() {
        return this.s3Configuration;
    }

    public void setS3Configuration(S3Configuration s3Configuration) {
        this.s3Configuration = s3Configuration;
    }
}

