/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.s3;

import cloud.orbit.actors.extensions.json.ActorReferenceModule;
import cloud.orbit.actors.extensions.s3.AWSConfigValue;
import cloud.orbit.actors.extensions.s3.S3Configuration;
import cloud.orbit.actors.runtime.DefaultDescriptorFactory;
import cloud.orbit.util.StringUtils;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3Client;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;

public class S3Connection {
    private AmazonS3Client s3Client;
    private ObjectMapper mapper;

    public S3Connection(S3Configuration s3Configuration) {
        this.initializeMapper();
        this.initializeS3(s3Configuration);
    }

    private void initializeMapper() {
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new ActorReferenceModule(DefaultDescriptorFactory.get()));
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.setVisibility(this.mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private void initializeS3(S3Configuration s3Configuration) {
        switch (s3Configuration.getCredentialType()) {
            case BASIC_CREDENTIALS: {
                this.s3Client = new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(s3Configuration.getAccessKey(), s3Configuration.getSecretKey()));
                break;
            }
            case BASIC_SESSION_CREDENTIALS: {
                this.s3Client = new AmazonS3Client((AWSCredentials)new BasicSessionCredentials(s3Configuration.getAccessKey(), s3Configuration.getSecretKey(), s3Configuration.getSessionToken()));
                break;
            }
            default: {
                this.s3Client = new AmazonS3Client((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
            }
        }
        String awsRegion = StringUtils.defaultIfBlank((String)s3Configuration.getRegion(), (String)AWSConfigValue.getRegion());
        if (StringUtils.isNotBlank((CharSequence)awsRegion)) {
            this.s3Client.setRegion(Region.getRegion((Regions)Regions.fromName((String)awsRegion)));
        }
        if (StringUtils.isNotBlank((CharSequence)s3Configuration.getEndpoint())) {
            this.s3Client.setEndpoint(s3Configuration.getEndpoint());
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public AmazonS3Client getS3Client() {
        return this.s3Client;
    }
}

