/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.s3;

import cloud.orbit.actors.extensions.s3.AmazonCredentialType;

public class S3Configuration {
    private AmazonCredentialType credentialType;
    private String accessKey;
    private String secretKey;
    private String sessionToken;
    private String region;
    private String endpoint;

    public AmazonCredentialType getCredentialType() {
        return this.credentialType;
    }

    public void setCredentialType(AmazonCredentialType credentialType) {
        this.credentialType = credentialType;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public static class Builder {
        private S3Configuration s3Configuration = new S3Configuration();

        public Builder withCredentialType(AmazonCredentialType credentialType) {
            this.s3Configuration.setCredentialType(credentialType);
            return this;
        }

        public Builder withAccessKey(String accessKey) {
            this.s3Configuration.setAccessKey(accessKey);
            return this;
        }

        public Builder withSecretKey(String secretKey) {
            this.s3Configuration.setSecretKey(secretKey);
            return this;
        }

        public Builder withSessionToken(String sessionToken) {
            this.s3Configuration.setSessionToken(sessionToken);
            return this;
        }

        public Builder withRegion(String region) {
            this.s3Configuration.setRegion(region);
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.s3Configuration.setEndpoint(endpoint);
            return this;
        }

        public S3Configuration build() {
            return this.s3Configuration;
        }
    }
}

