/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.rest.async;

import cloud.orbit.rest.async.GenericUtils;
import cloud.orbit.rest.shaded.com.googlecode.gentyref.GenericTypeReflector;
import cloud.orbit.rest.shaded.org.objectweb.asm.ClassWriter;
import cloud.orbit.rest.shaded.org.objectweb.asm.Label;
import cloud.orbit.rest.shaded.org.objectweb.asm.MethodVisitor;
import cloud.orbit.rest.shaded.org.objectweb.asm.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class RestClient {
    private static final Map<String, Class<? extends RestInvocationCallback>> invocationClasses;
    private static final Class<? extends CompletableFuture> futureClass;
    private final WebTarget target;
    private final MultivaluedHashMap<String, Object> headers;
    private Map<Class<?>, Object> proxies = new ConcurrentHashMap();

    public RestClient(String basePath) {
        this(RestClient.createWebTarget(basePath));
    }

    public RestClient(WebTarget webTarget) {
        this.target = webTarget;
        this.headers = new MultivaluedHashMap();
    }

    public RestClient(WebTarget target, MultivaluedHashMap<String, Object> headers) {
        this.target = target;
        this.headers = headers;
    }

    private static WebTarget createWebTarget(String basePath) {
        return ClientBuilder.newBuilder().build().target(basePath);
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return new MultivaluedHashMap(this.headers);
    }

    public <T extends RestClient> T setHeaders(MultivaluedMap<String, Object> headers) {
        MultivaluedHashMap newHeaders = new MultivaluedHashMap();
        for (Map.Entry e : headers.entrySet()) {
            newHeaders.put(e.getKey(), new ArrayList((Collection)e.getValue()));
        }
        return this.newClient(this.target, (MultivaluedHashMap<String, Object>)newHeaders);
    }

    public <T extends RestClient> T setHeader(String key, String value) {
        MultivaluedHashMap newHeaders = new MultivaluedHashMap(this.headers);
        newHeaders.putSingle((Object)key, (Object)value);
        return this.newClient(this.target, (MultivaluedHashMap<String, Object>)newHeaders);
    }

    public <T extends RestClient> T addHeader(String key, String value) {
        MultivaluedHashMap newHeaders = new MultivaluedHashMap(this.headers);
        newHeaders.add((Object)key, (Object)value);
        return this.newClient(this.target, (MultivaluedHashMap<String, Object>)newHeaders);
    }

    protected <T extends RestClient> T newClient(WebTarget target, MultivaluedHashMap<String, Object> headers) {
        return (T)new RestClient(target, headers);
    }

    public <T> T get(Class<T> interfaceClass) {
        Object proxy = this.proxies.get(interfaceClass);
        if (proxy == null) {
            WebTarget interfaceTarget = RestClient.addPath(this.target, interfaceClass);
            proxy = Proxy.newProxyInstance(RestClient.class.getClassLoader(), new Class[]{interfaceClass}, (theProxy, method, args) -> this.invoke(interfaceClass, interfaceTarget, method, args));
            this.proxies.put(interfaceClass, proxy);
        }
        return (T)proxy;
    }

    protected static <TThrowable extends Throwable, TResult> TResult reThrow(Throwable throwable) throws TThrowable {
        throw throwable;
    }

    protected Object handleInvokeException(Throwable e) {
        return RestClient.reThrow(e);
    }

    private Object invoke(Class<?> interfaceClass, WebTarget localTarget, Method method, Object[] args) {
        try {
            Object invokeResult = this.invokeInternal(interfaceClass, localTarget, method, args);
            if (invokeResult instanceof CompletionStage) {
                return ((CompletionStage)invokeResult).exceptionally(e -> this.handleInvokeException((Throwable)e));
            }
            return invokeResult;
        }
        catch (Throwable e2) {
            return this.handleInvokeException(e2);
        }
    }

    private Object invokeInternal(Class<?> interfaceClass, WebTarget localTarget, Method method, Object[] args) {
        java.lang.reflect.Type methodGenericReturnType = method.getGenericReturnType();
        java.lang.reflect.Type genericReturnType = this.getActualType(method.getReturnType(), methodGenericReturnType);
        String httpMethod = this.getHttpMethod(method);
        if (httpMethod == null) {
            throw new IllegalArgumentException("Method not annotate with a valid http method annotation" + method);
        }
        MultivaluedHashMap localHeaders = new MultivaluedHashMap();
        for (Map.Entry e : this.headers.entrySet()) {
            localHeaders.put(e.getKey(), new ArrayList((Collection)e.getValue()));
        }
        localTarget = RestClient.addPath(localTarget, method);
        Object entity = null;
        java.lang.reflect.Type entityType = null;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Object value = args[i];
            if (value instanceof CompletableFuture) {
                value = ((CompletableFuture)value).join();
            }
            if (value == null) {
                for (Annotation ann : parameterAnnotations[i]) {
                    if (!(ann instanceof DefaultValue)) continue;
                    value = ((DefaultValue)ann).value();
                }
            }
            int paramAnnotationCount = parameterAnnotations[i].length;
            for (Annotation ann : parameterAnnotations[i]) {
                if (ann instanceof PathParam) {
                    localTarget = localTarget.resolveTemplate(((PathParam)ann).value(), value);
                    continue;
                }
                if (ann instanceof QueryParam) {
                    localTarget = localTarget.queryParam(((QueryParam)ann).value(), new Object[]{value});
                    continue;
                }
                if (ann instanceof MatrixParam) {
                    localTarget = localTarget.matrixParam(((MatrixParam)ann).value(), new Object[]{value});
                    continue;
                }
                if (ann instanceof HeaderParam) {
                    if (value instanceof Collection) {
                        localHeaders.addAll((Object)((HeaderParam)ann).value(), ((Collection)value).toArray());
                        continue;
                    }
                    localHeaders.add((Object)((HeaderParam)ann).value(), value);
                    continue;
                }
                if (ann instanceof FormParam) {
                    throw new NotSupportedException("Form params are not supported " + method.getName() + " param " + i);
                }
                if (ann instanceof CookieParam) {
                    throw new NotSupportedException("Cookie params are not supported " + method.getName() + " param " + i);
                }
                --paramAnnotationCount;
            }
            if (paramAnnotationCount != 0) continue;
            entity = value;
            entityType = this.getActualType(method.getParameterTypes()[i], method.getGenericParameterTypes()[i]);
        }
        Invocation.Builder builder = localTarget.request();
        builder = builder.headers((MultivaluedMap)localHeaders);
        Produces produces = this.getAnnotation(interfaceClass, method, Produces.class);
        if (produces != null) {
            builder = builder.accept(produces.value());
        }
        GenericType responseGenericType = new GenericType(genericReturnType);
        if (entity != null) {
            String contentType = this.getContentType(interfaceClass, method, (MultivaluedHashMap<String, Object>)localHeaders);
            if (entityType instanceof ParameterizedType) {
                entity = new GenericEntity(entity, entityType);
            }
            if (CompletableFuture.class.isAssignableFrom(method.getReturnType())) {
                final CompletableFuture<Object> future = this.createFuture(method);
                if (genericReturnType == Void.class) {
                    builder.async().method(httpMethod, Entity.entity((Object)entity, (String)contentType), (InvocationCallback)new InvocationCallback<Object>(){

                        public void completed(Object obj) {
                            future.complete(obj);
                        }

                        public void failed(Throwable throwable) {
                            future.completeExceptionally(throwable);
                        }
                    });
                } else {
                    builder.async().method(httpMethod, Entity.entity((Object)entity, (String)contentType), RestClient.createAsyncInvocationCallback(genericReturnType).future(future));
                }
                return future;
            }
            return builder.method(httpMethod, Entity.entity((Object)entity, (String)contentType), responseGenericType);
        }
        if (CompletableFuture.class.isAssignableFrom(method.getReturnType())) {
            CompletableFuture<Object> future = this.createFuture(method);
            builder.async().method(httpMethod, RestClient.createAsyncInvocationCallback(genericReturnType).future(future));
            return future;
        }
        return builder.method(httpMethod, responseGenericType);
    }

    private String getContentType(Class<?> interfaceClass, Method method, MultivaluedHashMap<String, Object> headers) {
        List contentTypes = headers.get((Object)"Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty()) {
            return contentTypes.get(0).toString();
        }
        Consumes consumes = this.getAnnotation(interfaceClass, method, Consumes.class);
        if (consumes != null && consumes.value().length > 0) {
            return consumes.value()[0];
        }
        return null;
    }

    private java.lang.reflect.Type getActualType(Class rawType, java.lang.reflect.Type type) {
        if (CompletableFuture.class.isAssignableFrom(rawType)) {
            return GenericTypeReflector.getTypeParameter(type, CompletableFuture.class.getTypeParameters()[0]);
        }
        return type;
    }

    protected CompletableFuture<Object> createFuture(Method method) {
        try {
            return futureClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't instantiate future class: " + futureClass);
        }
    }

    private static WebTarget addPath(WebTarget target, AnnotatedElement element) {
        Path path = element.getAnnotation(Path.class);
        return path != null ? target.path(path.value()) : target;
    }

    private String getHttpMethod(Method method) {
        HttpMethod httpMethod = method.getAnnotation(HttpMethod.class);
        if (httpMethod != null) {
            return httpMethod.value();
        }
        for (Annotation an : method.getAnnotations()) {
            httpMethod = an.annotationType().getAnnotation(HttpMethod.class);
            if (httpMethod == null) continue;
            return httpMethod.value();
        }
        return null;
    }

    private <T extends Annotation> T getAnnotation(Class<?> interfaceClass, Method method, Class<T> annotationClass) {
        T annotation = method.getAnnotation(annotationClass);
        if (annotation == null) {
            return interfaceClass.getAnnotation(annotationClass);
        }
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RestInvocationCallback<?> createAsyncInvocationCallback(java.lang.reflect.Type type) {
        String genericSignature = GenericUtils.toGenericSignature(type);
        Class<RestInvocationCallback<Object>> clazz = invocationClasses.get(genericSignature);
        if (clazz == null) {
            Map<String, Class<? extends RestInvocationCallback>> map = invocationClasses;
            synchronized (map) {
                clazz = invocationClasses.get(genericSignature);
                if (clazz == null) {
                    clazz = RestClient.createInvocationCallbackClass(genericSignature);
                    invocationClasses.put(genericSignature, clazz);
                }
            }
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> createInvocationCallbackClass(String genericSignature) {
        Type superType = Type.getType(RestInvocationCallback.class);
        ClassWriter cw = new ClassWriter(0);
        String name = "cloud/orbit/rest/async/RestInvocationCallback_" + (genericSignature.hashCode() & 0xFFFF);
        String superName = superType.getInternalName();
        String signature = "L" + superName + "<" + genericSignature + ">;";
        cw.visit(52, 33, name, signature, superName, null);
        cw.visitInnerClass(superName, "cloud/orbit/rest/async/OrbitRestClient", "RestInvocationCallback", 9);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label lbStart = new Label();
        mv.visitLabel(lbStart);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superName, "<init>", "()V", false);
        mv.visitInsn(177);
        Label lbEnd = new Label();
        mv.visitLabel(lbEnd);
        mv.visitLocalVariable("this", "L" + name + ";", null, lbStart, lbEnd, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        byte[] bytes = cw.toByteArray();
        class Loader
        extends ClassLoader {
            Loader() {
                super(RestClient.class.getClassLoader());
            }

            public Class<?> define(String o, byte[] bytes) {
                return super.defineClass(o, bytes, 0, bytes.length);
            }
        }
        return new Loader().define(null, bytes);
    }

    public <T extends RestClient> T property(String propertyName, Object propertyValue) {
        return this.newClient((WebTarget)this.target.path("").property(propertyName, propertyValue), this.headers);
    }

    static {
        Class<Object> futureClass1;
        invocationClasses = new ConcurrentHashMap<String, Class<? extends RestInvocationCallback>>();
        try {
            futureClass1 = Class.forName("cloud.orbit.concurrent.Task");
        }
        catch (Exception e) {
            futureClass1 = CompletableFuture.class;
        }
        futureClass = futureClass1;
    }

    public static class RestInvocationCallback<T>
    implements InvocationCallback<T> {
        private CompletableFuture<?> future;

        public RestInvocationCallback<T> future(CompletableFuture<?> future) {
            this.future = future;
            return this;
        }

        public void completed(T response) {
            this.future.complete(response);
        }

        public void failed(Throwable throwable) {
            this.future.completeExceptionally(throwable);
        }
    }
}

